/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianDataOutputStream {
    private DataOutputStream outputStream;

    public EndianDataOutputStream(OutputStream outputStream) {
        this.outputStream = new DataOutputStream(outputStream);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.outputStream.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void writeByteLE(int n) throws IOException {
        this.outputStream.writeByte(n);
    }

    public void writeByteBE(int n) throws IOException {
        this.outputStream.writeByte(n);
    }

    public void writeBytesLE(String string) throws IOException {
        this.outputStream.writeBytes(string);
    }

    public void writeBytesBE(String string) throws IOException {
        this.outputStream.writeBytes(string);
    }

    public void writeShortBE(int n) throws IOException {
        this.outputStream.writeShort(n);
    }

    public void writeShortLE(int n) throws IOException {
        this.outputStream.writeByte(n);
        this.outputStream.writeByte(n >> 8);
    }

    public void writeIntBE(int n) throws IOException {
        this.outputStream.writeInt(n);
    }

    public void writeIntLE(int n) throws IOException {
        this.outputStream.writeByte(n);
        this.outputStream.writeByte(n >> 8);
        this.outputStream.writeByte(n >> 16);
        this.outputStream.writeByte(n >> 24);
    }

    public void writeLongBE(long l) throws IOException {
        this.outputStream.writeLong(l);
    }

    public void writeLongLE(long l) throws IOException {
        this.outputStream.writeByte((byte)l);
        this.outputStream.writeByte((byte)(l >> 8));
        this.outputStream.writeByte((byte)(l >> 16));
        this.outputStream.writeByte((byte)(l >> 24));
        this.outputStream.writeByte((byte)(l >> 32));
        this.outputStream.writeByte((byte)(l >> 40));
        this.outputStream.writeByte((byte)(l >> 48));
        this.outputStream.writeByte((byte)(l >> 56));
    }

    public void writeDoubleBE(double d) throws IOException {
        this.outputStream.writeDouble(d);
    }

    public void writeDoubleLE(double d) throws IOException {
        this.writeLongLE(Double.doubleToLongBits(d));
    }
}

