/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.util.MathUtil;

public class EnvelopeUtil {
    private static GeometryFactory factory = new GeometryFactory();

    public static Envelope expand(Envelope envelope, double d) {
        if (d < 0.0) {
            double d2 = 2.0 * -d;
            if (envelope.getWidth() < d2) {
                return new Envelope();
            }
            if (envelope.getHeight() < d2) {
                return new Envelope();
            }
        }
        return new Envelope(envelope.getMinX() - d, envelope.getMaxX() + d, envelope.getMinY() - d, envelope.getMaxY() + d);
    }

    public static void translate(Envelope envelope, Coordinate coordinate) {
        if (envelope.isNull()) {
            return;
        }
        envelope.init(envelope.getMinX() + coordinate.x, envelope.getMaxX() + coordinate.x, envelope.getMinY() + coordinate.y, envelope.getMaxY() + coordinate.y);
    }

    public static Envelope bufferByFraction(Envelope envelope, double d) {
        Envelope envelope2 = new Envelope(envelope);
        double d2 = (envelope2.getWidth() + envelope2.getHeight()) / 2.0;
        double d3 = d2 * d;
        if (d2 == 0.0) {
            d3 = 10.0;
        }
        envelope2.expandToInclude(envelope2.getMaxX() + d3, envelope2.getMaxY() + d3);
        envelope2.expandToInclude(envelope2.getMinX() - d3, envelope2.getMinY() - d3);
        return envelope2;
    }

    public static Coordinate centre(Envelope envelope) {
        return new Coordinate(MathUtil.avg(envelope.getMinX(), envelope.getMaxX()), MathUtil.avg(envelope.getMinY(), envelope.getMaxY()));
    }

    public static Geometry toGeometry(Envelope envelope) {
        if (envelope.getWidth() == 0.0 && envelope.getHeight() == 0.0) {
            return factory.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        if (envelope.getWidth() == 0.0 || envelope.getHeight() == 0.0) {
            return factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())});
        }
        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }
}

