/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FeatureUtil {
    private static int lastID = 0;

    public static Feature toFeature(Geometry geometry, FeatureSchema featureSchema) {
        BasicFeature basicFeature = new BasicFeature(featureSchema);
        basicFeature.setGeometry(geometry);
        return basicFeature;
    }

    public static List toGeometries(Collection collection) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            arrayList.add(feature.getGeometry());
        }
        return arrayList;
    }

    public static int nextID() {
        return ++lastID;
    }

    public static void copyAttributes(Feature feature, Feature feature2) {
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            feature2.setAttribute(i, feature.getAttribute(i));
        }
    }

    public static boolean areAllNonSpatialAttributesNull(Feature feature) {
        for (int i = 0; i < feature.getSchema().getAttributeCount(); ++i) {
            if (AttributeType.GEOMETRY == feature.getSchema().getAttributeType(i) || feature.getAttribute(i) == null) continue;
            return false;
        }
        return true;
    }
}

