/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;

public class Albers
extends Projection {
    double L0;
    double k0;
    double phi1;
    double phi2;
    double phi0;
    double X0;
    double Y0;
    double A_n;
    double A_C;
    double A_p0;
    Geographic q = new Geographic();

    public void setParameters(double d, double d2, double d3, double d4, double d5, double d6) {
        this.L0 = d * Math.PI / 180.0;
        this.phi1 = d2 * Math.PI / 180.0;
        this.phi2 = d3 * Math.PI / 180.0;
        this.phi0 = d4 * Math.PI / 180.0;
        this.X0 = d5;
        this.Y0 = d6;
        double d7 = this.albersM(this.phi1);
        double d8 = this.albersM(this.phi2);
        double d9 = this.albersQ(this.phi1);
        double d10 = this.albersQ(this.phi2);
        double d11 = this.albersQ(this.phi0);
        this.A_n = (d7 * d7 - d8 * d8) / (d10 - d9);
        this.A_C = d7 * d7 + this.A_n * d9;
        double d12 = this.currentSpheroid.getA();
        this.A_p0 = d12 * Math.sqrt(this.A_C - this.A_n * d11) / this.A_n;
    }

    public Planar asPlanar(Geographic geographic, Planar planar) {
        this.q.lat = geographic.lat / 180.0 * Math.PI;
        this.q.lon = geographic.lon / 180.0 * Math.PI;
        this.forward(this.q, planar);
        return planar;
    }

    public Geographic asGeographic(Planar planar, Geographic geographic) {
        this.inverse(planar, geographic);
        geographic.lat = geographic.lat * 180.0 / Math.PI;
        geographic.lon = geographic.lon * 180.0 / Math.PI;
        return geographic;
    }

    void forward(Geographic geographic, Planar planar) {
        double d = this.currentSpheroid.getA();
        double d2 = this.albersQ(geographic.lat);
        double d3 = this.A_n * (geographic.lon - this.L0);
        double d4 = d * Math.sqrt(this.A_C - this.A_n * d2) / this.A_n;
        planar.x = d4 * Math.sin(d3) + this.X0;
        planar.y = this.A_p0 - d4 * Math.cos(d3) + this.Y0;
    }

    void inverse(Planar planar, Geographic geographic) {
        double d = this.currentSpheroid.getA();
        double d2 = this.currentSpheroid.getE();
        double d3 = d2 * d2;
        double d4 = planar.x - this.X0;
        double d5 = planar.y - this.Y0;
        double d6 = Math.atan2(d4, this.A_p0 - d5);
        double d7 = Math.sqrt(d4 * d4 + Math.pow(this.A_p0 - d5, 2.0));
        double d8 = (this.A_C - d7 * d7 * this.A_n * this.A_n / (d * d)) / this.A_n;
        geographic.lon = this.L0 + d6 / this.A_n;
        double d9 = Math.asin(d8 / 2.0);
        double d10 = 1.0E11;
        do {
            double d11 = Math.pow(1.0 - d3 * Math.pow(Math.sin(d9), 2.0), 2.0) / (2.0 * Math.cos(d9));
            double d12 = d8 / (1.0 - d3);
            double d13 = Math.sin(d9) / (1.0 - d3 * Math.pow(Math.sin(d9), 2.0));
            double d14 = 1.0 / (2.0 * d2) * Math.log((1.0 - d2 * Math.sin(d9)) / (1.0 + d2 * Math.sin(d9)));
            double d15 = d9 + d11 * (d12 - d13 + d14);
            d10 = Math.abs(d15 - d9);
            d9 = d15;
        } while (d10 > 1.0E-12);
        geographic.lat = d9;
    }

    double albersQ(double d) {
        double d2 = this.currentSpheroid.getE();
        double d3 = (1.0 - d2 * d2) * (Math.sin(d) / (1.0 - d2 * d2 * Math.pow(Math.sin(d), 2.0)) - 1.0 / (2.0 * d2) * Math.log((1.0 - d2 * Math.sin(d)) / (1.0 + d2 * Math.sin(d))));
        return d3;
    }

    double albersM(double d) {
        double d2 = this.currentSpheroid.getE();
        double d3 = Math.cos(d) / Math.sqrt(1.0 - d2 * d2 * Math.pow(Math.sin(d), 2.0));
        return d3;
    }
}

