/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.CommonBitsRemover;

public class CommonBitsOp {
    private boolean returnToOriginalPrecision = true;
    private CommonBitsRemover cbr;

    public CommonBitsOp() {
        this(true);
    }

    public CommonBitsOp(boolean bl) {
        this.returnToOriginalPrecision = bl;
    }

    public Geometry intersection(Geometry geometry, Geometry geometry2) {
        Geometry[] geometryArray = this.removeCommonBits(geometry, geometry2);
        return this.computeResultPrecision(geometryArray[0].intersection(geometryArray[1]));
    }

    public Geometry union(Geometry geometry, Geometry geometry2) {
        Geometry[] geometryArray = this.removeCommonBits(geometry, geometry2);
        return this.computeResultPrecision(geometryArray[0].union(geometryArray[1]));
    }

    public Geometry difference(Geometry geometry, Geometry geometry2) {
        Geometry[] geometryArray = this.removeCommonBits(geometry, geometry2);
        return this.computeResultPrecision(geometryArray[0].difference(geometryArray[1]));
    }

    public Geometry symDifference(Geometry geometry, Geometry geometry2) {
        Geometry[] geometryArray = this.removeCommonBits(geometry, geometry2);
        return this.computeResultPrecision(geometryArray[0].symDifference(geometryArray[1]));
    }

    private Geometry computeResultPrecision(Geometry geometry) {
        if (this.returnToOriginalPrecision) {
            this.cbr.addCommonBits(geometry);
        }
        return geometry;
    }

    private Geometry removeCommonBits(Geometry geometry) {
        this.cbr = new CommonBitsRemover();
        this.cbr.add(geometry);
        Geometry geometry2 = this.cbr.removeCommonBits((Geometry)geometry.clone());
        return geometry2;
    }

    private Geometry[] removeCommonBits(Geometry geometry, Geometry geometry2) {
        this.cbr = new CommonBitsRemover();
        this.cbr.add(geometry);
        this.cbr.add(geometry2);
        Geometry[] geometryArray = new Geometry[]{this.cbr.removeCommonBits((Geometry)geometry.clone()), this.cbr.removeCommonBits((Geometry)geometry2.clone())};
        return geometryArray;
    }
}

