/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;
    private List lineEdgesList = new ArrayList();
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp overlayOp, GeometryFactory geometryFactory, PointLocator pointLocator) {
        this.op = overlayOp;
        this.geometryFactory = geometryFactory;
        this.ptLocator = pointLocator;
    }

    public List build(int n) {
        this.findCoveredLineEdges();
        this.collectLines(n);
        this.buildLines(n);
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        Object object;
        Iterator iterator = this.op.getGraph().getNodes().iterator();
        while (iterator.hasNext()) {
            object = (Node)iterator.next();
            ((DirectedEdgeStar)((Node)object).getEdges()).findCoveredLineEdges();
        }
        iterator = this.op.getGraph().getEdgeEnds().iterator();
        while (iterator.hasNext()) {
            object = (DirectedEdge)iterator.next();
            Edge edge = ((DirectedEdge)object).getEdge();
            if (!((DirectedEdge)object).isLineEdge() || edge.isCoveredSet()) continue;
            boolean bl = this.op.isCoveredByA(((EdgeEnd)object).getCoordinate());
            edge.setCovered(bl);
        }
    }

    private void collectLines(int n) {
        Iterator iterator = this.op.getGraph().getEdgeEnds().iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            this.collectLineEdge(directedEdge, n, this.lineEdgesList);
            this.collectBoundaryTouchEdge(directedEdge, n, this.lineEdgesList);
        }
    }

    public void collectLineEdge(DirectedEdge directedEdge, int n, List list) {
        Label label = directedEdge.getLabel();
        Edge edge = directedEdge.getEdge();
        if (directedEdge.isLineEdge() && !directedEdge.isVisited() && OverlayOp.isResultOfOp(label, n) && !edge.isCovered()) {
            list.add(edge);
            directedEdge.setVisitedEdge(true);
        }
    }

    public void collectBoundaryTouchEdge(DirectedEdge directedEdge, int n, List list) {
        Label label = directedEdge.getLabel();
        if (!(directedEdge.isLineEdge() || directedEdge.isInteriorAreaEdge() || directedEdge.getEdge().isInResult() || directedEdge.isVisited() || !OverlayOp.isResultOfOp(label, n) || n != 1)) {
            list.add(directedEdge.getEdge());
            directedEdge.setVisitedEdge(true);
        }
    }

    private void buildLines(int n) {
        Iterator iterator = this.lineEdgesList.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Label label = edge.getLabel();
            LineString lineString = this.geometryFactory.createLineString(edge.getCoordinates());
            this.resultLineList.add(lineString);
            edge.setInResult(true);
        }
    }

    private void labelIsolatedLines(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Label label = edge.getLabel();
            if (!edge.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedLine(edge, 0);
                continue;
            }
            this.labelIsolatedLine(edge, 1);
        }
    }

    private void labelIsolatedLine(Edge edge, int n) {
        int n2 = this.ptLocator.locate(edge.getCoordinate(), this.op.getArgGeometry(n));
        edge.getLabel().setLocation(n, n2);
    }
}

