/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.MonotoneChainIndexer;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;

public class MonotoneChainEdge {
    Edge e;
    Coordinate[] pts;
    int[] startIndex;
    Envelope env1 = new Envelope();
    Envelope env2 = new Envelope();

    public MonotoneChainEdge(Edge edge) {
        this.e = edge;
        this.pts = edge.getCoordinates();
        MonotoneChainIndexer monotoneChainIndexer = new MonotoneChainIndexer();
        this.startIndex = monotoneChainIndexer.getChainStartIndices(this.pts);
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public int[] getStartIndexes() {
        return this.startIndex;
    }

    public double getMinX(int n) {
        double d = this.pts[this.startIndex[n]].x;
        double d2 = this.pts[this.startIndex[n + 1]].x;
        return d < d2 ? d : d2;
    }

    public double getMaxX(int n) {
        double d = this.pts[this.startIndex[n]].x;
        double d2 = this.pts[this.startIndex[n + 1]].x;
        return d > d2 ? d : d2;
    }

    public void computeIntersects(MonotoneChainEdge monotoneChainEdge, SegmentIntersector segmentIntersector) {
        for (int i = 0; i < this.startIndex.length - 1; ++i) {
            for (int j = 0; j < monotoneChainEdge.startIndex.length - 1; ++j) {
                this.computeIntersectsForChain(i, monotoneChainEdge, j, segmentIntersector);
            }
        }
    }

    public void computeIntersectsForChain(int n, MonotoneChainEdge monotoneChainEdge, int n2, SegmentIntersector segmentIntersector) {
        this.computeIntersectsForChain(this.startIndex[n], this.startIndex[n + 1], monotoneChainEdge, monotoneChainEdge.startIndex[n2], monotoneChainEdge.startIndex[n2 + 1], segmentIntersector);
    }

    private void computeIntersectsForChain(int n, int n2, MonotoneChainEdge monotoneChainEdge, int n3, int n4, SegmentIntersector segmentIntersector) {
        Coordinate coordinate = this.pts[n];
        Coordinate coordinate2 = this.pts[n2];
        Coordinate coordinate3 = monotoneChainEdge.pts[n3];
        Coordinate coordinate4 = monotoneChainEdge.pts[n4];
        if (n2 - n == 1 && n4 - n3 == 1) {
            segmentIntersector.addIntersections(this.e, n, monotoneChainEdge.e, n3);
            return;
        }
        this.env1.init(coordinate, coordinate2);
        this.env2.init(coordinate3, coordinate4);
        if (!this.env1.intersects(this.env2)) {
            return;
        }
        int n5 = (n + n2) / 2;
        int n6 = (n3 + n4) / 2;
        if (n < n5) {
            if (n3 < n6) {
                this.computeIntersectsForChain(n, n5, monotoneChainEdge, n3, n6, segmentIntersector);
            }
            if (n6 < n4) {
                this.computeIntersectsForChain(n, n5, monotoneChainEdge, n6, n4, segmentIntersector);
            }
        }
        if (n5 < n2) {
            if (n3 < n6) {
                this.computeIntersectsForChain(n5, n2, monotoneChainEdge, n3, n6, segmentIntersector);
            }
            if (n6 < n4) {
                this.computeIntersectsForChain(n5, n2, monotoneChainEdge, n6, n4, segmentIntersector);
            }
        }
    }
}

