/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeometryCollectionIterator
implements Iterator {
    private GeometryCollection parent;
    private boolean atStart;
    private int max;
    private int index;
    private GeometryCollectionIterator subcollectionIterator;

    public GeometryCollectionIterator(GeometryCollection geometryCollection) {
        this.parent = geometryCollection;
        this.atStart = true;
        this.index = 0;
        this.max = geometryCollection.getNumGeometries();
    }

    public boolean hasNext() {
        if (this.atStart) {
            return true;
        }
        if (this.subcollectionIterator != null) {
            if (this.subcollectionIterator.hasNext()) {
                return true;
            }
            this.subcollectionIterator = null;
        }
        return this.index < this.max;
    }

    public Object next() {
        Geometry geometry;
        if (this.atStart) {
            this.atStart = false;
            return this.parent;
        }
        if (this.subcollectionIterator != null) {
            if (this.subcollectionIterator.hasNext()) {
                return this.subcollectionIterator.next();
            }
            this.subcollectionIterator = null;
        }
        if (this.index >= this.max) {
            throw new NoSuchElementException();
        }
        if ((geometry = this.parent.getGeometryN(this.index++)) instanceof GeometryCollection) {
            this.subcollectionIterator = new GeometryCollectionIterator((GeometryCollection)geometry);
            return this.subcollectionIterator.next();
        }
        return geometry;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

