
/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */
package resources;

import java.io.*;
import java.awt.*;
import java.util.Iterator;
import application.*;

/**
 * Class defining a Classroom Scheduler Professor
 */

public class Professor implements Constants, Comparable, Serializable {
    static final long serialVersionUID = 911;
    
    // Possible status of instructor
    public static final int FULL_TIME = 1;
    public static final int ADJUNCT = 2;
    public static final int OTHER = 3;
    
    protected int status;    // one of FULL_TIME, ADJUNCT, OTHER
    protected String firstName;
    protected String lastName;
    
    /**
     * Constructor declaration
     *
     *
     * @param String firstName
     * @param String lastName
     * @param String status
     *
     */
    
    public Professor(String firstName, String lastName, int status) {
        this.firstName = firstName;
        this.lastName = lastName;
        
        if (status == FULL_TIME || status == ADJUNCT) {
            this.status = status;
        } else {
            this.status = OTHER;
        }
    }
    
    // accessors and mutators
    
    /**
     * @return String firstName
     */
    
    public String getFirstName() {
        return firstName;
    }
    
    /**
     * @return String lastName
     */
    
    public String getLastName() {
        return lastName;
    }
    
    /**
     * @return int status
     */
    
    public int getStatus() {
        return status;
    }
    
    /**
     * @param String firstName
     */
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    
    /**
     * @param String lastName
     */
    
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    
    /**
     * @param int status
     */
    
    public void setStatus(int status) {
        this.status = status;
    }
    
    /**
     * @returns String representation of this Professor
     */
    
    public String toString() {
        if (lastName.trim().equals("STAFF")) {
            return lastName;
        }
        
        return lastName + ", " + firstName;
    }
    
    // implement the Comparable interface for sorting
    
    public int compareTo(Object obj) {
        if (!(obj instanceof Professor)) return 0;
        
        if (!lastName.equals(((Professor)obj).lastName))
            return lastName.compareTo(((Professor)obj).lastName);
        else if(!firstName.equals(((Professor)obj).firstName))
            return firstName.compareTo(((Professor)obj).firstName);
        
        return 0;
    }
    
    public boolean equals(Object obj) {
        if(!(obj instanceof Professor)){
            return false;
        }
        Professor professor2 = (Professor) obj;
        
        if (compareTo(professor2) == 0 && status == professor2.status)
            return true;
        return false;
    }
    
    // Draw the graphical schedule for this professor
    
    public void draw(Graphics g, Rectangle r) {
        //System.out.println("drawing a prof : " + r);
        Schedule schedule = Schedule.getSchedule();
        
        Iterator it = schedule.getSchedCourses().iterator();
        
        while (it.hasNext()){
            SchedCourse schedCourse = (SchedCourse) it.next();
            
            if (this.equals(schedCourse.getProfessor())) {
                schedCourse.drawGraphical(g, SchedCourse.PROFESSOR, r);
            }
        }
    }
}

