/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;
import javax.swing.*;
import application.*;
import resources.*;

/**
 *
 * @author  Colin
 */
public class ViewCharts extends javax.swing.JPanel implements Observer{
    
    /** Creates new form ViewCharts */
    public ViewCharts() {
        initComponents();
        addListeners();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        chartChoice = new javax.swing.ButtonGroup();
        choicePanel = new javax.swing.JPanel();
        profRadioButton = new javax.swing.JRadioButton();
        availableProfs = new javax.swing.JComboBox();
        roomRadioButton = new javax.swing.JRadioButton();
        availableRooms = new javax.swing.JComboBox();
        chartScrollPane = new javax.swing.JScrollPane();
        printPanel = new javax.swing.JPanel();
        printThis = new javax.swing.JButton();
        printAllSimilar = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        choicePanel.setLayout(new java.awt.GridBagLayout());

        choicePanel.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        choicePanel.setMaximumSize(new java.awt.Dimension(173, 2147483647));
        profRadioButton.setSelected(true);
        profRadioButton.setToolTipText("View the schedule for a single classroom or a single professor");
        chartChoice.add(profRadioButton);
        profRadioButton.setActionCommand("professor");
        profRadioButton.setLabel("Professor");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 52);
        choicePanel.add(profRadioButton, gridBagConstraints);

        availableProfs.setMaximumRowCount(20);
        availableProfs.setToolTipText("Pick the Prof  to display");
        availableProfs.setMaximumSize(new java.awt.Dimension(40, 32767));
        availableProfs.setMinimumSize(new java.awt.Dimension(40, 25));
        availableProfs.setPreferredSize(new java.awt.Dimension(40, 25));
        availableProfs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                availableProfsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 96;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 25);
        choicePanel.add(availableProfs, gridBagConstraints);

        roomRadioButton.setToolTipText("View the schedule for a single classroom or a single professor");
        chartChoice.add(roomRadioButton);
        roomRadioButton.setActionCommand("classroom");
        roomRadioButton.setLabel("Classroom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 47);
        choicePanel.add(roomRadioButton, gridBagConstraints);

        availableRooms.setMaximumRowCount(20);
        availableRooms.setToolTipText("Pick the classroom to display.");
        availableRooms.setMaximumSize(new java.awt.Dimension(40, 32767));
        availableRooms.setMinimumSize(new java.awt.Dimension(40, 25));
        availableRooms.setPreferredSize(new java.awt.Dimension(40, 25));
        availableRooms.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 96;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 12, 25);
        choicePanel.add(availableRooms, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new java.awt.Insets(137, 20, 18, 9);
        add(choicePanel, gridBagConstraints);

        chartScrollPane.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        chartScrollPane.setPreferredSize(new java.awt.Dimension(450, 700));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 18, 0);
        add(chartScrollPane, gridBagConstraints);

        printPanel.setLayout(new java.awt.GridBagLayout());

        printPanel.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        printPanel.setMaximumSize(new java.awt.Dimension(173, 85));
        printPanel.setMinimumSize(new java.awt.Dimension(173, 85));
        printPanel.setPreferredSize(new java.awt.Dimension(173, 85));
        printThis.setText("Print This View");
        printThis.setToolTipText("Send this page only to printer");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        printPanel.add(printThis, gridBagConstraints);

        printAllSimilar.setText("Print All Similar Views");
        printAllSimilar.setToolTipText("Prints all rooms, or all full-time profs");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 6, 6);
        printPanel.add(printAllSimilar, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 9);
        add(printPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void availableProfsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_availableProfsActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_availableProfsActionPerformed

    public void update(Observable o, Object arg) {
        // findout which of the radio buttons is selected and populate the combobox
        //   and change the label for the combobox
        if(profRadioButton.isSelected()){
            availableProfs.removeAllItems();
            availableProfs.setEnabled(true);
            availableRooms.setEnabled(false);
            Iterator it = schedule.getProfessors().iterator();
            while(it.hasNext())
                availableProfs.addItem(it.next());
        } else {
            availableRooms.removeAllItems();
            availableProfs.setEnabled(false);
            availableRooms.setEnabled(true);
            availableRooms.setEnabled(false);
            Iterator it = schedule.getClassrooms().iterator();
            while(it.hasNext())
                availableRooms.addItem(it.next());
        }
    }    
    private void addListeners(){
        ShowIt listener = new ShowIt();
        profRadioButton.addActionListener(listener);
        roomRadioButton.addActionListener(listener);        
        availableProfs.addActionListener(listener);        
        availableRooms.addActionListener(listener);
        printThis.addActionListener(listener);
        printAllSimilar.addActionListener(listener);
        
        //schedTable.setPreferredScrollableViewportSize(new Dimension(450, 700)); 
        chartScrollPane.setPreferredSize(new Dimension(450, 700));
        chartScrollPane.setViewportView(viewGraphSched);
        chartScrollPane.revalidate();       
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox availableProfs;
    private javax.swing.JComboBox availableRooms;
    private javax.swing.ButtonGroup chartChoice;
    private javax.swing.JScrollPane chartScrollPane;
    private javax.swing.JPanel choicePanel;
    private javax.swing.JButton printAllSimilar;
    private javax.swing.JPanel printPanel;
    private javax.swing.JButton printThis;
    private javax.swing.JRadioButton profRadioButton;
    private javax.swing.JRadioButton roomRadioButton;
    // End of variables declaration//GEN-END:variables
    private Schedule schedule = Schedule.getSchedule();
    private ViewGraphSched viewGraphSched = new ViewGraphSched(null);
    
    class ShowIt implements ActionListener {        
        public void actionPerformed(ActionEvent ae) {
            if(ae.getActionCommand().equalsIgnoreCase("Professor")){
                availableProfs.setEnabled(true);
                availableRooms.setEnabled(false);
                availableProfs.removeAllItems();
                Iterator it = schedule.getProfessors().iterator();
                while(it.hasNext())
                    availableProfs.addItem(it.next());
                viewGraphSched.setViewProf((Professor) (availableProfs.getSelectedItem()));
                printAllSimilar.setEnabled(true);
            } else if(ae.getActionCommand().equalsIgnoreCase("Classroom")){
                availableProfs.setEnabled(false);
                availableRooms.setEnabled(true);
                availableRooms.removeAllItems();
                Iterator it = schedule.getClassrooms().iterator();
                while(it.hasNext())
                    availableRooms.addItem(it.next());
                viewGraphSched.setViewRoom((Classroom) (availableRooms.getSelectedItem()));
                printAllSimilar.setEnabled(true);
                
            } else if(ae.getSource() == availableProfs){
                viewGraphSched.setViewProf((Professor) (availableProfs.getSelectedItem()));
                chartScrollPane.revalidate(); // Let the JScrollPane know that somethings changed
            } else if(ae.getSource() == availableRooms){
                viewGraphSched.setViewRoom((Classroom) (availableRooms.getSelectedItem()));
                chartScrollPane.revalidate(); // Let the JScrollPane know that somethings changed
            }else if (ae.getSource() == printThis) {  // printing
                printTheView(viewGraphSched, true);
            } else if (ae.getSource() == printAllSimilar) {
                  if (roomRadioButton.isSelected()) {
                    System.out.println("Print all the rooms");
                    
                    Iterator it = schedule.getClassrooms().iterator();
                    while (it.hasNext()) {
                        viewGraphSched.setViewRoom((Classroom)(it.next()));
                        printTheView(viewGraphSched, false);                        
                    }                    
                }
                
                if (profRadioButton.isSelected()) {
                    System.out.println("Print all the full time profs");
                    
                    Iterator it = schedule.getProfessors().iterator();
                    while (it.hasNext()) {
                        Professor p = (Professor)(it.next());
                        if ( p.getStatus() == Professor.FULL_TIME) {
                            viewGraphSched.setViewProf(p);
                            printTheView(viewGraphSched, false);
                        }
                    }                    
                }
            }
        }
    }
    // this is a helper for the actionListener
    
    private void printTheView(Pageable toPrint, boolean confirm) {
        
        PrinterJob printJob = PrinterJob.getPrinterJob();  // Get a printing object
        printJob.setPageable(toPrint);    // The schedule is printable
        
        if (confirm) {
            if (printJob.printDialog())   // Display print dialog
            {                                        // If true is returned...
                try {
                    printJob.print();                // then print
                }
                catch(PrinterException pe) {
                    System.out.println(pe);
                    JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(),
                    "Error printing a schedule.",
                    "Unknown Printer Error",
                    JOptionPane.ERROR_MESSAGE);
                }
            }
        } else {
            try {
                printJob.print();                // then print
            }
            catch(PrinterException pe) {
                System.out.println(pe);
                JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(),
                "Error printing a schedule.", "Unknown Printer Error",
                JOptionPane.ERROR_MESSAGE);
            }
        }
    }

}
