/*
 * Decompiled with CFR 0.152.
 */
package resources;

import application.Schedule;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import resources.Constants;
import resources.SchedCourse;

public class Classroom
implements Constants,
Comparable,
Serializable {
    static final long serialVersionUID = 911L;
    private String building;
    private String roomName;
    private int capacity;

    public Classroom(String building, String roomName, int capacity) {
        this.capacity = capacity;
        this.roomName = roomName;
        this.building = building;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public String toString() {
        if (this.roomName.trim().equals("TBA")) {
            return this.roomName;
        }
        return this.building + "-" + this.roomName + " (" + this.capacity + ")";
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Classroom)) {
            return 0;
        }
        if (!this.building.equals(((Classroom)obj).building)) {
            return this.building.compareTo(((Classroom)obj).building);
        }
        if (!this.roomName.equals(((Classroom)obj).roomName)) {
            return this.roomName.compareTo(((Classroom)obj).roomName);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Classroom)) {
            return false;
        }
        Classroom room2 = (Classroom)obj;
        return this.roomName.equals(room2.roomName) && this.building.equals(room2.building) && this.capacity == room2.capacity;
    }

    public void draw(Graphics g, Rectangle r) {
        Schedule schedule = Schedule.getSchedule();
        for (SchedCourse schedCourse : schedule.getSchedCourses()) {
            if (!this.equals(schedCourse.getClassroom())) continue;
            schedCourse.drawGraphical(g, 1, r);
        }
    }
}

