/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import panels.ScheduleTableModel;
import resources.Classroom;
import resources.Course;
import resources.Professor;
import resources.SchedCourse;
import resources.TimeSlot;

public class ScheduleCoursePanel
extends Box
implements Observer {
    private JLabel label;
    private JTable schedTable;
    private ScheduleTableModel scheduleTableModel;
    private TableColumn classroomColumn;
    private TableColumn timeSlotColumn;
    private TableColumn professorColumn;
    private TableColumn courseColumn;
    private JScrollPane scheduleScrollPane;
    private JList courseList;
    private JScrollPane courseScrollPane;
    private JComboBox professorCB;
    private JComboBox timeSlotCB;
    private JComboBox classroomCB;
    private JComboBox professorTableCB;
    private JComboBox timeSlotTableCB;
    private JComboBox classroomTableCB;
    private JButton addButton;
    private JButton deleteButton;
    private ScheduleCoursePanelListener scheduleCoursePanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private Component parent;

    public ScheduleCoursePanel(Component parent) {
        super(0);
        this.parent = parent;
        this.makeWidgets();
        this.doTheLayout();
        this.addToolTips();
        this.addListeners();
    }

    public void update(Observable o, Object arg) {
        this.scheduleTableModel.fireTableDataChanged();
        ArrayList courses = this.schedule.getCourses();
        Vector<Course> unScheduledCourses = new Vector<Course>(20, 10);
        for (Course course : courses) {
            if (course.getIsScheduled()) continue;
            unScheduledCourses.add(course);
        }
        this.courseList.setListData(unScheduledCourses);
        this.professorCB.removeAllItems();
        Iterator it = this.schedule.getProfessors().iterator();
        while (it.hasNext()) {
            this.professorCB.addItem(it.next());
        }
        this.timeSlotCB.removeAllItems();
        it = this.schedule.getTimeSlots().iterator();
        while (it.hasNext()) {
            this.timeSlotCB.addItem(it.next());
        }
        this.classroomCB.removeAllItems();
        it = this.schedule.getClassrooms().iterator();
        while (it.hasNext()) {
            this.classroomCB.addItem(it.next());
        }
        this.professorTableCB.removeAllItems();
        it = this.schedule.getProfessors().iterator();
        while (it.hasNext()) {
            this.professorTableCB.addItem(it.next());
        }
        this.timeSlotTableCB.removeAllItems();
        it = this.schedule.getTimeSlots().iterator();
        while (it.hasNext()) {
            this.timeSlotTableCB.addItem(it.next());
        }
        this.classroomTableCB.removeAllItems();
        it = this.schedule.getClassrooms().iterator();
        while (it.hasNext()) {
            this.classroomTableCB.addItem(it.next());
        }
    }

    private void makeWidgets() {
        this.professorCB = new JComboBox();
        this.timeSlotCB = new JComboBox();
        this.classroomCB = new JComboBox();
        this.professorTableCB = new JComboBox();
        this.timeSlotTableCB = new JComboBox();
        this.classroomTableCB = new JComboBox();
        this.addButton = new JButton(" Add To Schedule ");
        this.deleteButton = new JButton(" Remove Selected Item(s) ");
        this.courseList = new JList();
        this.courseList.setVisibleRowCount(15);
        this.courseList.setSelectionMode(2);
        this.courseScrollPane = new JScrollPane(this.courseList, 22, 30);
        this.scheduleTableModel = new ScheduleTableModel();
        this.schedTable = new JTable(this.scheduleTableModel);
        this.scheduleScrollPane = new JScrollPane(this.schedTable, 22, 30);
        this.schedTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.courseColumn = this.schedTable.getColumnModel().getColumn(0);
        this.classroomColumn = this.schedTable.getColumnModel().getColumn(1);
        this.timeSlotColumn = this.schedTable.getColumnModel().getColumn(2);
        this.professorColumn = this.schedTable.getColumnModel().getColumn(3);
        this.classroomColumn.setCellEditor(new DefaultCellEditor(this.classroomTableCB));
        this.timeSlotColumn.setCellEditor(new DefaultCellEditor(this.timeSlotTableCB));
        this.professorColumn.setCellEditor(new DefaultCellEditor(this.professorTableCB));
    }

    private void doTheLayout() {
        this.add(Box.createHorizontalGlue());
        this.add(Box.createHorizontalStrut(25));
        Box leftPanel = new Box(1);
        Box rightPanel = new Box(1);
        leftPanel.add(Box.createVerticalStrut(25));
        leftPanel.add(this.scheduleScrollPane);
        leftPanel.add(Box.createVerticalStrut(25));
        leftPanel.add(this.deleteButton);
        leftPanel.add(Box.createVerticalStrut(25));
        this.add(leftPanel);
        this.add(Box.createHorizontalStrut(25));
        rightPanel.add(Box.createVerticalStrut(25));
        this.label = (JLabel)rightPanel.add(new JLabel("Courses not in schedule:"));
        this.label.setAlignmentX(0.0f);
        rightPanel.add(this.courseScrollPane);
        this.label = (JLabel)rightPanel.add(new JLabel("Time Slot:"));
        this.label.setAlignmentX(0.0f);
        rightPanel.add(this.timeSlotCB);
        rightPanel.add(Box.createVerticalStrut(5));
        this.label = (JLabel)rightPanel.add(new JLabel("Classroom:"));
        this.label.setAlignmentX(0.0f);
        rightPanel.add(this.classroomCB);
        rightPanel.add(Box.createVerticalStrut(5));
        this.label = (JLabel)rightPanel.add(new JLabel("Professor:"));
        this.label.setAlignmentX(0.0f);
        rightPanel.add(this.professorCB);
        rightPanel.add(Box.createVerticalStrut(25));
        rightPanel.add(this.addButton);
        rightPanel.add(Box.createVerticalStrut(25));
        this.add(rightPanel);
        this.add(Box.createHorizontalStrut(25));
        this.add(Box.createHorizontalGlue());
    }

    private void addToolTips() {
        this.courseList.setToolTipText("Select a course to schedule");
        this.professorCB.setToolTipText("Select a Professor");
        this.timeSlotCB.setToolTipText("Select a Time Slot");
        this.classroomCB.setToolTipText("Select a Classroom");
        this.addButton.setToolTipText("Add this item to the schedule");
        this.deleteButton.setToolTipText("Remove the selected items(s) from the list of scheduled courses");
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        this.classroomColumn.setCellRenderer(renderer);
        this.timeSlotColumn.setCellRenderer(renderer);
        this.professorColumn.setCellRenderer(renderer);
        renderer.setToolTipText("Click to change the value in this cell");
        DefaultTableCellRenderer rendererForCourseCol = new DefaultTableCellRenderer();
        this.courseColumn.setCellRenderer(rendererForCourseCol);
        rendererForCourseCol.setToolTipText("Select courses to be un-scheduled");
    }

    private void addListeners() {
        this.scheduleCoursePanelListener = new ScheduleCoursePanelListener();
        this.addButton.addActionListener(this.scheduleCoursePanelListener);
        this.deleteButton.addActionListener(this.scheduleCoursePanelListener);
        this.classroomTableCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ScheduleCoursePanel.this.schedTable.getEditingRow();
                if (row >= 0) {
                    Classroom c = (Classroom)((JComboBox)e.getSource()).getSelectedItem();
                    SchedCourse courseModified = (SchedCourse)ScheduleCoursePanel.this.schedule.getSchedCourses().get(row);
                    courseModified.setClassroom(c);
                    ScheduleCoursePanel.this.scheduleTableModel.fireTableDataChanged();
                    ScheduleCoursePanel.this.schedule.setChanged(true);
                }
            }
        });
        this.timeSlotTableCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ScheduleCoursePanel.this.schedTable.getEditingRow();
                if (row >= 0) {
                    TimeSlot t = (TimeSlot)((JComboBox)e.getSource()).getSelectedItem();
                    SchedCourse courseModified = (SchedCourse)ScheduleCoursePanel.this.schedule.getSchedCourses().get(row);
                    courseModified.setTimeSlot(t);
                    ScheduleCoursePanel.this.scheduleTableModel.fireTableDataChanged();
                    ScheduleCoursePanel.this.schedule.setChanged(true);
                }
            }
        });
        this.professorTableCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ScheduleCoursePanel.this.schedTable.getEditingRow();
                if (row >= 0) {
                    Professor p = (Professor)((JComboBox)e.getSource()).getSelectedItem();
                    SchedCourse courseModified = (SchedCourse)ScheduleCoursePanel.this.schedule.getSchedCourses().get(row);
                    courseModified.setProfessor(p);
                    ScheduleCoursePanel.this.scheduleTableModel.fireTableDataChanged();
                    ScheduleCoursePanel.this.schedule.setChanged(true);
                }
            }
        });
    }

    class ScheduleCoursePanelListener
    implements ActionListener {
        ScheduleCoursePanelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            block7: {
                block6: {
                    if (e.getSource() != ScheduleCoursePanel.this.addButton) break block6;
                    Course[] coursesToSchedule = (Course[])ScheduleCoursePanel.this.courseList.getSelectedValues();
                    if (coursesToSchedule.length == 0) {
                        JOptionPane.showMessageDialog(ScheduleCoursePanel.this.parent, "Select a course to be scheduled");
                        return;
                    }
                    Professor profToSchedule = (Professor)ScheduleCoursePanel.this.professorCB.getSelectedItem();
                    if (profToSchedule == null) {
                        JOptionPane.showMessageDialog(ScheduleCoursePanel.this.parent, "Select a professor to be scheduled");
                        return;
                    }
                    TimeSlot timeSlotToSchedule = (TimeSlot)ScheduleCoursePanel.this.timeSlotCB.getSelectedItem();
                    if (timeSlotToSchedule == null) {
                        JOptionPane.showMessageDialog(ScheduleCoursePanel.this.parent, "Select a time slot to schedule");
                        return;
                    }
                    int selected = ScheduleCoursePanel.this.classroomCB.getSelectedIndex();
                    if (selected < 0) {
                        JOptionPane.showMessageDialog(ScheduleCoursePanel.this.parent, "Select a room to schedule");
                        return;
                    }
                    Classroom classroomToSchedule = (Classroom)ScheduleCoursePanel.this.schedule.getClassrooms().get(selected);
                    for (int i = 0; i < coursesToSchedule.length; ++i) {
                        SchedCourse theNewScheduledCourse = new SchedCourse(profToSchedule, classroomToSchedule, coursesToSchedule[i], timeSlotToSchedule);
                        ScheduleCoursePanel.this.schedule.addSchedCourse(theNewScheduledCourse);
                    }
                    break block7;
                }
                if (e.getSource() != ScheduleCoursePanel.this.deleteButton) break block7;
                int[] selected = ScheduleCoursePanel.this.schedTable.getSelectedRows();
                for (int i = selected.length - 1; i >= 0; --i) {
                    ScheduleCoursePanel.this.schedule.removeSchedCourse((SchedCourse)ScheduleCoursePanel.this.schedule.getSchedCourses().get(selected[i]));
                }
            }
        }
    }
}

