/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import javax.swing.table.AbstractTableModel;
import resources.Classroom;

class RoomsTableModel
extends AbstractTableModel {
    private Schedule schedule;
    final String[] columnNames = new String[]{"Building", "Room", "Capacity"};

    public RoomsTableModel() {
        this.schedule = Schedule.getSchedule();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.schedule.getClassrooms().size();
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int c) {
        return " ".getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public Object getValueAt(int row, int col) {
        Classroom classroom = (Classroom)this.schedule.getClassrooms().get(row);
        switch (col) {
            case 0: {
                return classroom.getBuilding();
            }
            case 1: {
                return classroom.getRoomName();
            }
            case 2: {
                return "" + classroom.getCapacity();
            }
        }
        return "";
    }

    public void setValueAt(Object value, int row, int col) {
    }
}

