/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorTextChooserPanel
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = 1L;
    private String aText;
    private ResourceBundle aResources;

    public ColorTextChooserPanel(String pText) {
        this.aText = pText;
        this.aResources = ResourceBundle.getBundle(ColorTextChooserPanel.class.getName());
    }

    public String getDisplayName() {
        return this.aResources.getString("title");
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public String getText() {
        return this.aText;
    }

    public void updateChooser() {
    }

    protected void buildChooser() {
        GridBagLayout lLayout = new GridBagLayout();
        this.setLayout(lLayout);
        JLabel lLabel = new JLabel(this.aResources.getString("label"));
        this.add(lLabel);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 0;
        lConstraints.gridy = 0;
        lConstraints.anchor = 11;
        lConstraints.weighty = 1.0;
        lLayout.setConstraints(lLabel, lConstraints);
        final JTextField lTextField = new JTextField(this.aText, 50);
        lTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent pEvent) {
                this.handleChange();
            }

            public void insertUpdate(DocumentEvent pEvent) {
                this.handleChange();
            }

            public void removeUpdate(DocumentEvent pEvent) {
                this.handleChange();
            }

            private void handleChange() {
                ColorTextChooserPanel.this.aText = lTextField.getText();
            }
        });
        this.add(lTextField);
        lConstraints = new GridBagConstraints();
        lConstraints.gridx = 1;
        lConstraints.gridy = 0;
        lConstraints.anchor = 11;
        lConstraints.weightx = 1.0;
        lConstraints.weightx = 1.0;
        lConstraints.fill = 2;
        lLayout.setConstraints(lTextField, lConstraints);
    }
}

