/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Robot;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sf.accolorhelper.filter.AtypicalMonochromaticFilter;
import net.sf.accolorhelper.filter.DeuteranomalyFilter;
import net.sf.accolorhelper.filter.ProtanopiaFilter;
import net.sf.accolorhelper.filter.TritanopiaFilter;
import net.sf.accolorhelper.ui.ColorOverviewComponent;
import net.sf.accolorhelper.ui.ColorSet;
import net.sf.accolorhelper.ui.DeficiencyLevel;
import net.sf.accolorhelper.ui.FilteringImageComponent;
import net.sf.accolorhelper.ui.NoDeficiencyComparisonComponent;
import net.sf.accolorhelper.ui.ScreenGrabber;
import net.sf.accolorhelper.ui.SpecificDeficiencyLevelColorSet;
import net.sf.accolorhelper.ui.SpecificDeficiencyLevelComparisonComponent;

public class AccolorHelperComponent
extends JPanel {
    private static final int SCREEN_GRAB_WIDTH = 350;
    private static final int SCREEN_GRAB_HEIGHT = 250;
    private static final long serialVersionUID = 1L;
    private ColorOverviewComponent aColorOverview;
    private NoDeficiencyComparisonComponent aNoDeficiencyComponent;
    private SpecificDeficiencyLevelComparisonComponent lWeakColorComponent;
    private SpecificDeficiencyLevelComparisonComponent lNoColorComponent;

    public AccolorHelperComponent(Color[] pColors) {
        ResourceBundle lResources = ResourceBundle.getBundle(AccolorHelperComponent.class.getName());
        GridBagLayout lLayout = new GridBagLayout();
        this.setLayout(lLayout);
        ColorSet lColorSet = new ColorSet(pColors);
        JTabbedPane lOuterPane = new JTabbedPane(1, 0);
        this.aColorOverview = new ColorOverviewComponent(pColors, lColorSet);
        JScrollPane lScrollPane = new JScrollPane(this.aColorOverview);
        lOuterPane.add(lResources.getString("tab.overview"), lScrollPane);
        this.aNoDeficiencyComponent = new NoDeficiencyComparisonComponent(pColors, lColorSet.aSelection);
        lOuterPane.add(lResources.getString("tab.normal"), this.aNoDeficiencyComponent);
        SpecificDeficiencyLevelColorSet lWeakColorSet = new SpecificDeficiencyLevelColorSet(DeficiencyLevel.WEAK, lColorSet);
        this.lWeakColorComponent = new SpecificDeficiencyLevelComparisonComponent(lWeakColorSet);
        lOuterPane.add(lResources.getString("tab.weakcolor"), this.lWeakColorComponent);
        SpecificDeficiencyLevelColorSet lNoColorSet = new SpecificDeficiencyLevelColorSet(DeficiencyLevel.SEVERE, lColorSet);
        this.lNoColorComponent = new SpecificDeficiencyLevelComparisonComponent(lNoColorSet);
        lOuterPane.add(lResources.getString("tab.missingcolor"), this.lNoColorComponent);
        this.add(lOuterPane);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.insets = new Insets(10, 10, 10, 10);
        lConstraints.weightx = 1.0;
        lConstraints.weighty = 1.0;
        lConstraints.fill = 1;
        lLayout.setConstraints(lOuterPane, lConstraints);
    }

    public void setColors(Color[] pColors) {
        ColorSet lColorSet = new ColorSet(pColors);
        this.aColorOverview.setColors(pColors, lColorSet);
        this.aNoDeficiencyComponent.setColors(pColors, lColorSet.aSelection);
        SpecificDeficiencyLevelColorSet lWeakColorSet = new SpecificDeficiencyLevelColorSet(DeficiencyLevel.WEAK, lColorSet);
        this.lWeakColorComponent.setColors(lWeakColorSet);
        SpecificDeficiencyLevelColorSet lNoColorSet = new SpecificDeficiencyLevelColorSet(DeficiencyLevel.SEVERE, lColorSet);
        this.lNoColorComponent.setColors(lNoColorSet);
    }

    private JComponent createScreenPane() {
        JPanel result = new JPanel();
        GridBagLayout lLayout = new GridBagLayout();
        result.setLayout(lLayout);
        FilteringImageComponent lProtanopiaComponent = new FilteringImageComponent(new ProtanopiaFilter(), 350, 250);
        result.add(lProtanopiaComponent);
        GridBagConstraints lConstraints = this.createConstraints(0, 0, false, false);
        lLayout.setConstraints(lProtanopiaComponent, lConstraints);
        FilteringImageComponent lDeuteranopiaComponent = new FilteringImageComponent(new DeuteranomalyFilter(), 350, 250);
        result.add(lDeuteranopiaComponent);
        lConstraints = this.createConstraints(1, 0, true, false);
        lLayout.setConstraints(lDeuteranopiaComponent, lConstraints);
        FilteringImageComponent lTritanopiaComponent = new FilteringImageComponent(new TritanopiaFilter(), 350, 250);
        result.add(lTritanopiaComponent);
        lConstraints = this.createConstraints(0, 1, false, true);
        lLayout.setConstraints(lTritanopiaComponent, lConstraints);
        FilteringImageComponent lMonochromaticComponent = new FilteringImageComponent(new AtypicalMonochromaticFilter(), 350, 250);
        result.add(lMonochromaticComponent);
        lConstraints = this.createConstraints(1, 1, true, true);
        lLayout.setConstraints(lMonochromaticComponent, lConstraints);
        try {
            Robot lRobot = new Robot();
            ScreenGrabber lGrabber = new ScreenGrabber(result, lRobot, 350, 250);
            lGrabber.addFilteringImageComponent(lProtanopiaComponent);
            lGrabber.addFilteringImageComponent(lDeuteranopiaComponent);
            lGrabber.addFilteringImageComponent(lTritanopiaComponent);
            lGrabber.addFilteringImageComponent(lMonochromaticComponent);
            Thread lThread = new Thread(lGrabber);
            lThread.setDaemon(true);
            lThread.start();
        }
        catch (AWTException e) {
            // empty catch block
        }
        return result;
    }

    private GridBagConstraints createConstraints(int pX, int pY, boolean pInsetOnRight, boolean pInsetOnBottom) {
        GridBagConstraints result = new GridBagConstraints();
        result.gridx = pX;
        result.gridy = pY;
        result.insets = new Insets(6, 6, pInsetOnBottom ? 6 : 0, pInsetOnRight ? 6 : 0);
        return result;
    }
}

