/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.filter;

import net.sf.accolorhelper.filter.AbstractColorFilter;
import net.sf.accolorhelper.filter.PrimaryColor;

public abstract class SinglePrimaryDeficiencyFilter
extends AbstractColorFilter {
    private static final double[] RGB_TO_LMS = new double[]{0.05059983, 0.08585369, 0.0095242, 0.01893033, 0.08925308, 0.01370054, 0.00292202, 0.00975732, 0.07145979};
    protected static final double[] ANCHOR = new double[]{0.08008, 0.1579, 0.5897, 0.1284, 0.2237, 0.3636, 0.9856, 0.7325, 0.001079, 0.0914, 0.007009, 0.0};
    protected static final double[] ANCHOR_E = new double[]{RGB_TO_LMS[0] + RGB_TO_LMS[1] + RGB_TO_LMS[2], RGB_TO_LMS[3] + RGB_TO_LMS[4] + RGB_TO_LMS[5], RGB_TO_LMS[6] + RGB_TO_LMS[7] + RGB_TO_LMS[8]};
    protected double aA1;
    protected double aB1;
    protected double aC1;
    protected double aA2;
    protected double aB2;
    protected double aC2;
    protected double aInflection;
    private static final double GAMMA_RGB = 2.1;
    private static final double[] GAMMA_LUT = new double[256];
    private static final double[] LMS_TO_RGB;

    public int filter(int pRgbValue) {
        double lRed = GAMMA_LUT[(pRgbValue & 0xFF0000) >> 16];
        double lGreen = GAMMA_LUT[(pRgbValue & 0xFF00) >> 8];
        double lBlue = GAMMA_LUT[pRgbValue & 0xFF];
        double lOldRed = lRed;
        double lOldGreen = lGreen;
        lRed = lOldRed * RGB_TO_LMS[0] + lOldGreen * RGB_TO_LMS[1] + lBlue * RGB_TO_LMS[2];
        lGreen = lOldRed * RGB_TO_LMS[3] + lOldGreen * RGB_TO_LMS[4] + lBlue * RGB_TO_LMS[5];
        lBlue = lOldRed * RGB_TO_LMS[6] + lOldGreen * RGB_TO_LMS[7] + lBlue * RGB_TO_LMS[8];
        switch (this.getAffectedPrimary()) {
            case RED: {
                lRed = this.modifyRgb(lRed, lGreen, lBlue);
                break;
            }
            case GREEN: {
                lGreen = this.modifyRgb(lRed, lGreen, lBlue);
                break;
            }
            case BLUE: {
                lBlue = this.modifyRgb(lRed, lGreen, lBlue);
            }
        }
        lOldRed = lRed;
        lOldGreen = lGreen;
        lRed = lOldRed * LMS_TO_RGB[0] + lOldGreen * LMS_TO_RGB[1] + lBlue * LMS_TO_RGB[2];
        lGreen = lOldRed * LMS_TO_RGB[3] + lOldGreen * LMS_TO_RGB[4] + lBlue * LMS_TO_RGB[5];
        lBlue = lOldRed * LMS_TO_RGB[6] + lOldGreen * LMS_TO_RGB[7] + lBlue * LMS_TO_RGB[8];
        int result = (this.lookupLut(lRed) << 16) + (this.lookupLut(lGreen) << 8) + this.lookupLut(lBlue);
        return result;
    }

    protected abstract PrimaryColor getAffectedPrimary();

    protected abstract double modifyRgb(double var1, double var3, double var5);

    private int lookupLut(double pValue) {
        int result = 127;
        boolean lHasBeenFound = false;
        for (int lStep = 64; !lHasBeenFound && lStep != 0; lStep /= 2) {
            if (GAMMA_LUT[result] > pValue) {
                result -= lStep;
                continue;
            }
            if (GAMMA_LUT[result + 1] > pValue) {
                lHasBeenFound = true;
                continue;
            }
            result += lStep;
        }
        if (result == 254 && GAMMA_LUT[255] < pValue) {
            result = 255;
        }
        return result;
    }

    static {
        for (int lIndex = 0; lIndex < 256; ++lIndex) {
            SinglePrimaryDeficiencyFilter.GAMMA_LUT[lIndex] = Math.pow(lIndex, 0.47619047619047616);
        }
        LMS_TO_RGB = new double[]{30.830854, -29.832659, 1.610474, -6.481468, 17.715578, -2.532642, -0.37569, -1.199062, 14.273846};
    }
}

