/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;

public class UnknownAttributesAttribute
extends Attribute {
    private ArrayList unknownAttributes = new ArrayList();
    public static String NAME = "UNKNOWN-ATTRIBUTES";

    UnknownAttributesAttribute() {
        super('\n');
    }

    public String getName() {
        return NAME;
    }

    public char getDataLength() {
        char len = (char)this.unknownAttributes.size();
        if (len % 2 != 0) {
            len = (char)(len + '\u0001');
        }
        return (char)(len * 2);
    }

    public void addAttributeID(char attributeID) {
        if (!this.contains(attributeID)) {
            this.unknownAttributes.add(new Character(attributeID));
        }
    }

    public boolean contains(char attributeID) {
        return this.unknownAttributes.contains(new Character(attributeID));
    }

    public Iterator getAttributes() {
        return this.unknownAttributes.iterator();
    }

    public int getAttributeCount() {
        return this.unknownAttributes.size();
    }

    public char getAttribute(int index) {
        return ((Character)this.unknownAttributes.get(index)).charValue();
    }

    public byte[] encode() {
        char att;
        byte[] binValue = new byte[this.getDataLength() + 4];
        int offset = 0;
        binValue[offset++] = (byte)(this.getAttributeType() >> 8);
        binValue[offset++] = (byte)(this.getAttributeType() & 0xFF);
        binValue[offset++] = (byte)(this.getDataLength() >> 8);
        binValue[offset++] = (byte)(this.getDataLength() & 0xFF);
        Iterator attributes = this.getAttributes();
        while (attributes.hasNext()) {
            att = ((Character)attributes.next()).charValue();
            binValue[offset++] = (byte)(att >> 8);
            binValue[offset++] = (byte)(att & 0xFF);
        }
        if (offset < binValue.length) {
            att = this.getAttribute(0);
            binValue[offset++] = (byte)(att >> 8);
            binValue[offset++] = (byte)(att & 0xFF);
        }
        return binValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnknownAttributesAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UnknownAttributesAttribute att = (UnknownAttributesAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && this.unknownAttributes.equals(att.unknownAttributes);
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length % 2 != 0) {
            throw new StunException("Attribute IDs are 2 bytes long and the passed binary array has an odd length value.");
        }
        int originalOffset = offset;
        for (int i = offset; i < originalOffset + length; i += 2) {
            int n = offset;
            int n2 = offset = (char)(offset + '\u0001');
            offset = (char)(offset + '\u0001');
            char attributeID = (char)(attributeValue[n] << 8 | attributeValue[n2]);
            this.addAttributeID(attributeID);
        }
    }
}

