/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;
import net.java.stun4j.attribute.ChangeRequestAttribute;
import net.java.stun4j.attribute.ChangedAddressAttribute;
import net.java.stun4j.attribute.ErrorCodeAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.attribute.ReflectedFromAttribute;
import net.java.stun4j.attribute.ResponseAddressAttribute;
import net.java.stun4j.attribute.SourceAddressAttribute;
import net.java.stun4j.attribute.UnknownAttributesAttribute;

public class AttributeDecoder {
    public static Attribute decode(byte[] bytes, char offset, char length) throws StunException {
        if (bytes == null || bytes.length < 4) {
            throw new StunException(2, "Could not decode the specified binary array.");
        }
        char attributeType = (char)(bytes[offset] << 8 | bytes[offset + '\u0001']);
        char attributeLength = (char)(bytes[offset + 2] << 8 | bytes[offset + 3]);
        if (attributeLength > bytes.length - offset) {
            throw new StunException(2, "The indicated attribute length (" + attributeLength + ") " + "does not match the length of the passed binary array");
        }
        Attribute decodedAttribute = null;
        switch (attributeType) {
            case '\u0003': {
                decodedAttribute = new ChangeRequestAttribute();
                break;
            }
            case '\u0005': {
                decodedAttribute = new ChangedAddressAttribute();
                break;
            }
            case '\u0001': {
                decodedAttribute = new MappedAddressAttribute();
                break;
            }
            case '\t': {
                decodedAttribute = new ErrorCodeAttribute();
                break;
            }
            case '\b': {
                throw new UnsupportedOperationException("The MESSAGE-INTEGRITY Attribute is not yet implemented.");
            }
            case '\u0007': {
                throw new UnsupportedOperationException("The PASSWORD Attribute is not yet implemented.");
            }
            case '\u000b': {
                decodedAttribute = new ReflectedFromAttribute();
                break;
            }
            case '\u0002': {
                decodedAttribute = new ResponseAddressAttribute();
                break;
            }
            case '\u0004': {
                decodedAttribute = new SourceAddressAttribute();
                break;
            }
            case '\n': {
                decodedAttribute = new UnknownAttributesAttribute();
                break;
            }
            case '\u0006': {
                throw new UnsupportedOperationException("The USERNAME Attribute is not yet implemented.");
            }
            default: {
                return null;
            }
        }
        decodedAttribute.setAttributeType(attributeType);
        decodedAttribute.decodeAttributeBody(bytes, (char)(4 + offset), attributeLength);
        return decodedAttribute;
    }
}

