/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.MediaRange;
import gov.nist.javax.sip.header.ParametersHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.AcceptHeader;

public class Accept
extends ParametersHeader
implements AcceptHeader {
    protected MediaRange mediaRange;

    public Accept() {
        super("Accept");
    }

    public boolean allowsAllContentTypes() {
        if (this.mediaRange == null) {
            return false;
        }
        return this.mediaRange.type.compareTo("*") == 0;
    }

    public boolean allowsAllContentSubTypes() {
        if (this.mediaRange == null) {
            return false;
        }
        return this.mediaRange.getSubtype().compareTo("*") == 0;
    }

    protected String encodeBody() {
        String s = "";
        if (this.mediaRange != null) {
            s = s + this.mediaRange.encode();
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            s = s + " ;" + this.parameters.encode();
        }
        return s;
    }

    public MediaRange getMediaRange() {
        return this.mediaRange;
    }

    public String getContentType() {
        if (this.mediaRange == null) {
            return null;
        }
        return this.mediaRange.getType();
    }

    public String getContentSubType() {
        if (this.mediaRange == null) {
            return null;
        }
        return this.mediaRange.getSubtype();
    }

    public float getQValue() {
        return this.getParameterAsFloat("q");
    }

    public boolean hasQValue() {
        return super.hasParameter("q");
    }

    public void removeQValue() {
        super.removeParameter("q");
    }

    public void setContentSubType(String subtype) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setSubtype(subtype);
    }

    public void setContentType(String type) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(type);
    }

    public void setQValue(float qValue) throws InvalidArgumentException {
        if (qValue == -1.0f) {
            super.removeParameter("q");
        }
        super.setParameter("q", qValue);
    }

    public void setMediaRange(MediaRange m) {
        this.mediaRange = m;
    }
}

