/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.IntColumn;
import borland.jbcl.dataset.InternalRow;
import borland.jbcl.dataset.KeyComparator;
import borland.jbcl.dataset.LocaleStringColumn;
import borland.jbcl.dataset.MatrixData;
import borland.jbcl.dataset.MemoryIndex;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.dataset.SortDescriptor;

class SortedMemoryIndex
extends MemoryIndex {
    private DataColumn[] keyDataColumns;
    private Column[] columns;
    private int columnCount;
    private boolean descending;
    private boolean caseInsensitive;
    private int replaceRow;
    private KeyComparator comparator;
    private int columnCompareCount;

    SortedMemoryIndex(SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, InternalRow internalRow, MatrixData matrixData, DataColumn[] dataColumnArray, int n, int n2, IntColumn intColumn, DataColumn[] dataColumnArray2, Column[] columnArray) {
        super(sortDescriptor, rowFilterListener, internalRow, matrixData, dataColumnArray, n, n2, intColumn);
        this.caseInsensitive = sortDescriptor.isCaseInsensitive();
        this.comparator = new KeyComparator(this.vector, dataColumnArray2, this.caseInsensitive);
        this.keyDataColumns = dataColumnArray2;
        this.columns = columnArray;
        this.columnCount = columnArray.length;
        this.descending = sortDescriptor.isDescending();
    }

    void growVector(int n) {
        super.growVector(n);
        this.comparator.setIndexVector(this.vector);
    }

    public final boolean add(int n) throws DataSetException {
        if (this.canAdd(n)) {
            int n2 = this.findClosest(n);
            if (n2 < 0) {
                n2 = 0;
            }
            this.vectorInsert(n2, n);
            return true;
        }
        return false;
    }

    public final void prepareReplace(int n) {
        this.replaceRow = this.findClosest(n);
    }

    public final void replace(int n) throws DataSetException {
        if (this.canAdd(n)) {
            if (this.replaceRow > 0) {
                this.compare(n, this.vector[this.replaceRow - 1]);
                if (this.comp <= 0) {
                    this.vectorDelete(this.replaceRow);
                    this.add(n);
                    this.replaceRow = -1;
                    return;
                }
            }
            if (this.replaceRow < this.lastRow) {
                this.compare(n, this.vector[this.replaceRow + 1]);
                if (this.comp >= 0) {
                    this.vectorDelete(this.replaceRow);
                    this.add(n);
                    this.replaceRow = -1;
                    return;
                }
            }
        } else {
            this.vectorDelete(this.replaceRow);
        }
        this.replaceRow = -1;
    }

    protected final void compare(int n, int n2) {
        this.comparator.compare(n, n2);
        this.comp = this.descending ? -this.comparator.comp : this.comparator.comp;
    }

    final int searchCompare(int n, int n2) {
        this.comparator.searchCompare(this.columnCompareCount, n, n2);
        this.comp = this.descending ? -this.comparator.comp : this.comparator.comp;
        return this.comp;
    }

    private final void quickSort(int n, int n2) {
        while (n2 - n > 4) {
            int n3;
            int n4 = (n + n2) / 2;
            if (this.comparator.compare(this.vector[n], this.vector[n4]) > 0) {
                n3 = this.vector[n];
                this.vector[n] = this.vector[n4];
                this.vector[n4] = n3;
            }
            if (this.comparator.compare(this.vector[n], this.vector[n2]) > 0) {
                n3 = this.vector[n];
                this.vector[n] = this.vector[n2];
                this.vector[n2] = n3;
            }
            if (this.comparator.compare(this.vector[n4], this.vector[n2]) > 0) {
                n3 = this.vector[n4];
                this.vector[n4] = this.vector[n2];
                this.vector[n2] = n3;
            }
            int n5 = n;
            int n6 = n2 - 1;
            n3 = this.vector[n4];
            this.vector[n4] = this.vector[n6];
            this.vector[n6] = n3;
            this.comparator.setPivot(n6);
            while (true) {
                this.comparator.findPivots(n5, n6);
                n5 = this.comparator.leftPivot;
                n6 = this.comparator.rightPivot;
                if (n5 >= n6) break;
                n3 = this.vector[n5];
                this.vector[n5] = this.vector[n6];
                this.vector[n6] = n3;
            }
            n3 = this.vector[n5];
            this.vector[n5] = this.vector[n2 - 1];
            this.vector[n2 - 1] = n3;
            if (n5 - n > n2 - n5) {
                this.quickSort(n5 + 1, n2);
                n2 = n5 - 1;
                continue;
            }
            this.quickSort(n, n5 - 1);
            n = n5 + 1;
        }
    }

    private final void insertionSort() {
        int n = this.lastRow + 1;
        int n2 = 0;
        while (++n2 < n) {
            int n3 = this.comparator.findInsertPoint(n2);
            if (n3 >= n2) continue;
            int n4 = this.vector[n2];
            int n5 = n2;
            while (n3 < n5) {
                this.vector[n5--] = this.vector[n5];
            }
            this.vector[n5] = n4;
        }
    }

    private final void reverseOrder() {
        int n = (this.lastRow + 1) / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = this.vector[i];
            this.vector[i] = this.vector[this.lastRow - i];
            this.vector[this.lastRow - i] = n2;
        }
    }

    void sort() {
        if (this.keyDataColumns[0] instanceof LocaleStringColumn) {
            ((LocaleStringColumn)this.keyDataColumns[0]).createCollationKeys();
        }
        this.comparator.disableReferenceCopy();
        this.quickSort(0, this.lastRow);
        if (!this.caseInsensitive) {
            this.comparator.enableReferenceCopy();
        }
        this.insertionSort();
        if (this.descending) {
            this.reverseOrder();
        }
    }

    public int locate(int n, int n2) throws DataSetException {
        boolean bl;
        int n3;
        if (n > this.lastRow) {
            return -1;
        }
        if (this.columnCount <= this.locateColumnCount) {
            for (n3 = 0; n3 < this.columns.length && this.columns[n3].ordinal == this.locateColumns[n3].ordinal; ++n3) {
            }
        }
        this.columnCompareCount = n3;
        if (this.columnCompareCount != this.locateColumnCount || (n2 & 8) != 0 != this.caseInsensitive) {
            return super.locate(n, n2);
        }
        if ((n2 & 2) != 0) {
            return this.keyLocateForwards(n);
        }
        if ((n2 & 4) != 0) {
            return this.keyLocateBackwards(n);
        }
        boolean bl2 = bl = (n2 & 0x40) == 0;
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        int n4 = this.find(0, bl);
        if (this.comp == 0 || this.locatePartialIndex != -1) {
            if (this.columnCount == this.locateColumnCount && this.locatePartialIndex == -1) {
                return n4;
            }
            if (bl) {
                return this.keyLocateForwards(n4);
            }
            return this.keyLocateBackwards(n4);
        }
        return -1;
    }

    final int find(int n, boolean bl) {
        int n2 = 0;
        int n3 = this.lastRow;
        int n4 = -1;
        while (true) {
            n4 = (n2 + n3) / 2;
            this.searchCompare(n, this.vector[n4]);
            if (this.comp == 0) {
                if (bl) {
                    if (n3 == n4) {
                        return n4;
                    }
                    n3 = n4;
                    continue;
                }
                if (n2 == n4) {
                    if (n2 == n3) {
                        return n4;
                    }
                    this.searchCompare(n, this.vector[n3]);
                    if (this.comp == 0) {
                        return n3;
                    }
                    this.comp = 0;
                    return n4;
                }
                n2 = n4;
                continue;
            }
            if (this.comp > 0) {
                if (n2 >= n3) {
                    return n4;
                }
                n2 = n4 + 1;
                continue;
            }
            if (this.comp >= 0) continue;
            if (n3 <= n2) {
                return n4;
            }
            n3 = n4 - 1;
        }
    }

    private final int keyLocateForwards(int n) {
        int n2 = this.lastRow + 1;
        if (this.locatePartialIndex != -1) {
            while (this.searchCompare(0, this.vector[n]) > 0 && n < n2) {
                ++n;
            }
            if (this.compareRow(n)) {
                return n;
            }
        } else {
            while (this.searchCompare(0, this.vector[n]) == 0 && n < n2) {
                if (this.columnCount == this.locateColumnCount || this.compareRow(n)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private final int keyLocateBackwards(int n) {
        if (this.locatePartialIndex != -1) {
            if (this.compareRow(n)) {
                return n;
            }
        } else {
            while (this.searchCompare(0, this.vector[n]) == 0 && n > -1) {
                if (this.columnCount == this.locateColumnCount || this.compareRow(n)) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }
}

