/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.view.LabelView;

public class LabelControl
extends LabelView
implements NavigationListener,
DataChangeListener,
AccessListener {
    private static final String nameBase = "labelControl";
    private static int nameCount = 1;
    private DataSet dataSet;
    private String columnName;
    private boolean initialized = false;

    public LabelControl() {
        this.setName(String.valueOf(nameBase).concat(String.valueOf(nameCount++)));
        this.setModel(new BasicSingletonContainer());
        this.setText(this.getName());
    }

    public LabelControl(String string) {
        this.setName(String.valueOf(nameBase).concat(String.valueOf(nameCount++)));
        this.setModel(new BasicSingletonContainer());
        this.setText(string);
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateText();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.updateText();
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.updateText();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.openDataSet(dataSet);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        this.bindDataSet();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
            this.dataSet.removeAccessListener(this);
        }
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
        } else if (this.initialized || this.dataSet.isOpen()) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException dataSetException) {
                    DataSetException.handleException(this.dataSet, this, dataSetException);
                    this.setModel(new BasicSingletonContainer());
                    return;
                }
                this.initialized = true;
            }
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column));
        }
    }
}

