/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Array;
import borland.jbcl.control.ColorChooserDialog;
import borland.jbcl.control.Res;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ColorChooser
implements WindowListener {
    public static final int OK = 1;
    public static final int CANCEL = 8;
    protected ColorChooserDialog dialog;
    protected Frame frame;
    protected String title;
    protected Color value;
    protected Array listeners = new Array();
    protected Component focus;
    protected int result;

    public ColorChooser(Frame frame, String string, Color color) {
        this.frame = frame;
        this.title = string;
        this.value = color;
        if (frame != null) {
            this.dialog = new ColorChooserDialog(frame, string, color);
        }
    }

    public ColorChooser(Frame frame, String string) {
        this(frame, string, null);
    }

    public ColorChooser(Frame frame) {
        this(frame, "", null);
    }

    public ColorChooser() {
        this(null, "", null);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
    }

    public String getTitle() {
        if (this.dialog != null) {
            this.title = this.dialog.getTitle();
        }
        return this.title;
    }

    public void setValue(Color color) {
        this.value = color;
        if (this.dialog != null) {
            this.dialog.setValue(color);
        }
    }

    public Color getValue() {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
        }
        return this.value;
    }

    public void setResult(int n) {
        this.result = n;
        if (this.dialog != null) {
            this.dialog.setResult(this.result);
        }
    }

    public int getResult() {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        return this.result;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res.getString(63));
                }
                this.dialog = new ColorChooserDialog(this.frame, this.title, this.value);
                this.dialog.setResult(this.result);
                this.dialog.addWindowListener(this);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.dialog.addActionListener((ActionListener)this.listeners.at(i));
                }
            }
            if (this.frame.isShowing()) {
                this.focus = this.frame.getFocusOwner();
            }
            this.dialog.show();
        } else if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.dialog != null) {
            this.dialog.addActionListener(actionListener);
        } else {
            this.listeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.dialog != null) {
            this.dialog.removeActionListener(actionListener);
        } else {
            this.listeners.remove(actionListener);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.value = this.dialog.getValue();
        this.result = this.dialog.getResult();
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
            this.result = this.dialog.getResult();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.focus != null) {
                this.focus.requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

