/*
 * Decompiled with CFR 0.152.
 */
package rath.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipManager {
    public static final int BUFFER_SIZE = 1024;
    public static final String FS;
    private String archiveRoot = System.getProperty("user.dir");

    public void setArchiveRoot(String directory) {
        this.archiveRoot = directory;
    }

    public String getArchiveRoot() {
        return this.archiveRoot;
    }

    public void doCompress(File file, File toCreate) throws IOException {
        if (toCreate.exists()) {
            throw new IOException(toCreate + " is already exist");
        }
        FileOutputStream fos = new FileOutputStream(toCreate);
        this.doCompress(file, fos);
    }

    public void doCompress(File file, OutputStream out) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        this.compress(file, zos);
        zos.setMethod(8);
        zos.close();
    }

    private void compress(File file, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.compress(files[i], zos);
                } else {
                    this.addFile(files[i], zos);
                }
                ++i;
            }
        } else if (file.isFile()) {
            this.addFile(file, zos);
        }
    }

    public void addFile(File file, ZipOutputStream zos) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.compressStarted(file);
        String enname = file.getAbsolutePath().substring(this.archiveRoot.length() + 1);
        ZipEntry en = new ZipEntry(enname);
        CRC32 crc32 = new CRC32();
        byte[] chs = new byte[1024];
        FileInputStream fis = new FileInputStream(file);
        int len = 0;
        while ((len = fis.read(chs)) > -1) {
            crc32.update(chs, 0, len);
        }
        fis.close();
        en.setSize(file.length());
        en.setTime(file.lastModified());
        en.setCrc(crc32.getValue());
        zos.putNextEntry(en);
        fis = new FileInputStream(file);
        while ((len = fis.read(chs)) > -1) {
            zos.write(chs, 0, len);
        }
        fis.close();
        zos.closeEntry();
        this.compressComplete(file);
    }

    protected void compressStarted(File file) {
    }

    protected void compressComplete(File file) {
    }

    static {
        BUFFER_SIZE = 1024;
        FS = System.getProperty("file.separator");
    }
}

