/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import rath.msnm.LocalCopy;

public class GlobalProp
extends Properties {
    private final File settingFile = new File(LocalCopy.DEFAULT_HOME_DIR, "Global.prop");

    public void load() {
        if (!this.settingFile.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(this.settingFile.getAbsolutePath());
            this.load(fis);
            fis.close();
        }
        catch (IOException e) {
            System.err.println("GlobalProp.load: " + e);
        }
    }

    public void store() {
        try {
            FileOutputStream fos = new FileOutputStream(this.settingFile.getAbsolutePath());
            this.store(fos, "JMSN Global setting file");
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            System.err.println("Global.store: " + e);
        }
    }

    public int getInt(String key) {
        String str = this.getProperty(key);
        if (str != null) {
            return Integer.parseInt(str);
        }
        this.setProperty(key, str);
        return -1;
    }

    public int getInt(String key, int def) {
        String str = this.getProperty(key);
        if (str != null) {
            return Integer.parseInt(str);
        }
        this.setProperty(key, String.valueOf(def));
        return def;
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public void set(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public void set(String key, String value) {
        this.setProperty(key, value);
    }
}

