/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;

public class AboutDialog
extends DefaultDialog
implements ToolBox {
    private ImageIcon icon;
    private ImageIcon logo;

    public AboutDialog(Frame owner) {
        super(owner);
        this.setTitle("JMSN Information");
        this.logo = new ImageIcon(this.getIconResource("logo.jpg"));
        this.createUI();
    }

    private URL getIconResource(String name) {
        return this.getClass().getResource("/resources/icon/" + name);
    }

    private void createUI() {
        this.setSize(435, 385);
        JPanel panel = (JPanel)this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        BoxLayout box = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(box);
        JLabel logoLabel = new JLabel(this.logo, 0);
        logoLabel.setText("JMSN Messenger v0.9.8b2");
        mainPanel.add(logoLabel);
        JLabel[] copyright = this.createCopyright();
        int i = 0;
        while (i < copyright.length) {
            mainPanel.add(copyright[i]);
            ++i;
        }
        JLabel l0 = new JLabel(" Author   Jang-Ho Hwang, rath@linuxkorea.co.kr ");
        l0.setFont(ToolBox.FONT_BOLD);
        l0.setBorder(BorderFactory.createEtchedBorder());
        JLabel l1 = new JLabel(" JMSN Homepage    http://jmsn.sourceforge.net/ ");
        l1.setFont(ToolBox.FONT_BOLD);
        l1.setBorder(BorderFactory.createEtchedBorder());
        Runtime rt = Runtime.getRuntime();
        long usage = rt.totalMemory() - rt.freeMemory() >> 10;
        final JLabel l2 = new JLabel(" Memory usage: " + usage + "KB");
        JButton gcButton = new JButton("Force GC");
        gcButton.setFont(ToolBox.FONT);
        gcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.gc();
                Runtime rt = Runtime.getRuntime();
                long usage = rt.totalMemory() - rt.freeMemory() >> 10;
                l2.setText(" Memory Usage: " + usage + "KB");
            }
        });
        JPanel memoryPanel = new JPanel();
        memoryPanel.setLayout(new BorderLayout());
        memoryPanel.setAlignmentX(0.0f);
        memoryPanel.add((Component)l2, "Center");
        memoryPanel.add((Component)gcButton, "East");
        mainPanel.add(l0);
        mainPanel.add(l1);
        mainPanel.add(memoryPanel);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        JButton closeButton = new JButton(Msg.get("button.close"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        closeButton.setFont(ToolBox.FONT);
        bottomPanel.add(closeButton);
        panel.add((Component)mainPanel, "Center");
        panel.add((Component)bottomPanel, "South");
    }

    private JLabel[] createCopyright() {
        ArrayList<String> list = new ArrayList<String>(25);
        list.add("");
        list.add("Copyright (c) 2002 Jang-Ho Hwang. All rights reserved.");
        list.add("");
        list.add("Redistribution and use in source and binary forms, with or without");
        list.add("modification, are permitted provided that the following conditions");
        list.add("are met:");
        list.add("1. Redistributions of source code must retain the above copyright");
        list.add("   notice, this list of conditions and the following disclaimer.");
        list.add("2. Redistributions in binary form must reproduce the above copyright");
        list.add("   notice, this list of conditions and the following disclaimer in the");
        list.add("   documentation and/or other materials provided with the distribution.");
        list.add("3. Neither the name of author nor the names of its contributors may");
        list.add("   be used to endorse or promote products derived from this software");
        list.add("   without specific prior written permission.");
        list.add("");
        JLabel[] l = new JLabel[list.size()];
        int i = 0;
        int len = list.size();
        while (i < len) {
            l[i] = new JLabel((String)list.get(i));
            l[i].setFont(ToolBox.FONT);
            ++i;
        }
        return l;
    }
}

