/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import rath.msnm.entity.MsnFriend;

public class ChatLogWriter {
    private static final SimpleDateFormat TIME = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final String LINE_SEP = System.getProperty("line.separator");
    private FileOutputStream fos = null;
    private PrintWriter out = null;

    public ChatLogWriter(File file) throws IOException {
        this.prepare(file);
    }

    private void prepare(File file) throws IOException {
        this.fos = new FileOutputStream(file.getAbsolutePath(), true);
        this.out = new PrintWriter(this.fos, true);
        this.out.println("-------------------------------------------------------");
        this.out.println(TIME.format(new Date()) + " CHAT SESSION STARTED");
        this.out.println("-------------------------------------------------------");
    }

    public void println(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(TIME.format(new Date()));
        sb.append(' ');
        sb.append(msg);
        this.out.println(sb.toString());
    }

    public void println(MsnFriend say, String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(TIME.format(new Date()));
        sb.append(' ');
        sb.append(say.getLoginName());
        sb.append(LINE_SEP);
        sb.append(msg);
        this.out.println(sb.toString());
    }

    public void close() {
        this.out.println("-------------------------------------------------------");
        this.out.println(TIME.format(new Date()) + " CHAT SESSION CLOSED");
        this.out.println("-------------------------------------------------------");
        this.out.println();
        this.out.flush();
        this.out.close();
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

