/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import rath.jmsn.ToolBox;
import rath.msnm.entity.MsnFriend;

public class EventViewer
extends JComboBox
implements ToolBox {
    private SimpleDateFormat sdf = new SimpleDateFormat("[HH:mm]");
    private int limitSize = 30;
    private boolean fireEvent = true;

    public EventViewer() {
        this.setFont(ToolBox.FONT);
    }

    public void setLimitSize(int size) {
        this.limitSize = size;
    }

    public int getLimitSize() {
        return this.limitSize;
    }

    public void addEvent(String msg, MsnFriend friend) {
        String view = this.sdf.format(new Date()) + " " + msg;
        this.insertItemAt(new Event(view, friend), 0);
        this.ensureLimitOverflow();
        this.fireEvent = false;
        this.setSelectedIndex(0);
        this.fireEvent = true;
    }

    protected void ensureLimitOverflow() {
        if (this.getItemCount() > this.limitSize) {
            int i = this.getItemCount() - 1;
            while (i >= this.limitSize) {
                this.removeItemAt(i);
                --i;
            }
        }
    }

    protected void fireActionEvent() {
        if (this.fireEvent) {
            super.fireActionEvent();
        }
    }

    public void clear() {
    }

    public static class Event {
        private String msg;
        private MsnFriend friend;

        private Event(String msg, MsnFriend friend) {
            this.msg = msg;
            this.friend = friend;
        }

        public MsnFriend getFriend() {
            return this.friend;
        }

        public String toString() {
            return this.msg;
        }
    }
}

