/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rath.jmsn.BuddyRenderer;
import rath.jmsn.MainFrame;
import rath.jmsn.entity.FileItem;
import rath.jmsn.ui.ChatDialog;
import rath.jmsn.util.BuddyComparator;
import rath.jmsn.util.Msg;
import rath.jmsn.util.MusicBox;
import rath.jmsn.util.UserStatusBox;
import rath.msnm.BuddyList;
import rath.msnm.GroupList;
import rath.msnm.LocalCopy;
import rath.msnm.MSNMessenger;
import rath.msnm.SwitchboardSession;
import rath.msnm.entity.Group;
import rath.msnm.entity.MsnFriend;
import rath.msnm.event.MsnAdapter;
import rath.msnm.event.MsnListener;
import rath.msnm.msg.MimeMessage;

public class BuddyTree
extends JTree
implements DragSourceListener,
DragGestureListener,
DropTargetListener,
TreeExpansionListener {
    private MsnFriend me = null;
    private MSNMessenger msnm = null;
    private MainFrame main = null;
    private Image chatIcon = null;
    private DefaultTreeModel model = null;
    private DefaultMutableTreeNode root = null;
    private MouseAdapter treeMouseAdapter = new BuddyMouseAdapter();
    private boolean offView = true;
    private Hashtable groupMap = new Hashtable();
    private Hashtable sessionMap = new Hashtable();
    private Hashtable dialogMap = new Hashtable();
    private DragSource dragSource = new DragSource();
    private int nonUpdateCount = 0;
    private Hashtable expandGroupMap = new Hashtable();
    private Image backImage = null;
    private BuddyComparator comparator = new BuddyComparator();
    public BuddyRenderer renderer = new BuddyRenderer();
    private int dragStartGroup = -1;
    private int oldDraggingIndex = -1;

    public BuddyTree(MainFrame m) {
        this.main = m;
        this.msnm = m.getMessenger();
        this.msnm.addMsnListener((MsnListener)new Listener());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setBackground(Color.white);
        this.setCellRenderer(this.renderer);
        this.addTreeExpansionListener(this);
        this.addMouseListener(this.treeMouseAdapter);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DefaultMutableTreeNode o = (DefaultMutableTreeNode)BuddyTree.this.getLastSelectedPathComponent();
                    if (o == null) {
                        return;
                    }
                    Object uo = o.getUserObject();
                    if (uo instanceof MsnFriend && o != BuddyTree.this.root) {
                        MsnFriend friend = (MsnFriend)uo;
                        BuddyTree.this.createNewSession(friend);
                    }
                }
            }
        });
        this.getSelectionModel().setSelectionMode(1);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, this);
        this.chatIcon = new ImageIcon(this.getClass().getResource("/resources/icon/chat.jpg")).getImage();
        this.setOpaque(false);
    }

    public void setBackgroundImage(Image image) {
        if (this.backImage != null) {
            this.backImage.flush();
        }
        this.backImage = image;
        this.repaint();
    }

    public Image getBackgroundImage() {
        return this.backImage;
    }

    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj != null && obj instanceof MsnFriend) {
            MsnFriend friend = (MsnFriend)obj;
            return friend.getLoginName();
        }
        return null;
    }

    public void start(MsnFriend i) {
        this.me = i;
        this.me.setStatus(this.msnm.getInitialStatus());
        this.me.setGroupIndex(-1);
        this.root = new DefaultMutableTreeNode(this.me);
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.expandRow(0);
        this.renderer.forward = this.msnm.getBuddyGroup().getForwardList();
        this.renderer.block = this.msnm.getBuddyGroup().getBlockList();
        this.syncAllUsers();
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof Group) {
            Group group = (Group)o;
            this.expandGroupMap.remove(group.getIndex());
        }
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof Group) {
            Group group = (Group)o;
            this.expandGroupMap.put(group.getIndex(), path);
        }
    }

    protected DefaultMutableTreeNode findGroupNode(Integer groupIndex) {
        return (DefaultMutableTreeNode)this.groupMap.get(groupIndex);
    }

    void syncAllUsers() {
        if (this.root == null) {
            return;
        }
        this.root.removeAllChildren();
        Iterator i = this.groupMap.values().iterator();
        while (i.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
            node.removeAllChildren();
        }
        this.groupMap.clear();
        GroupList gl = this.msnm.getBuddyGroup().getGroupList();
        gl.sort();
        Iterator i2 = gl.iterator();
        while (i2.hasNext()) {
            Group group = (Group)i2.next();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(group);
            this.root.add(node);
            this.groupMap.put(group.getIndex(), node);
        }
        BuddyList bl = this.msnm.getBuddyGroup().getForwardList();
        bl.sort((Comparator)this.comparator);
        Iterator i3 = bl.iterator();
        while (i3.hasNext()) {
            MsnFriend friend = (MsnFriend)i3.next();
            if (!this.offView && friend.getStatus().equals("FLN")) continue;
            DefaultMutableTreeNode node = this.findGroupNode(friend.getGroupIndex());
            DefaultMutableTreeNode fnode = new DefaultMutableTreeNode(friend);
            node.add(fnode);
        }
        this.model.reload();
        this.recoverExpandState();
    }

    private void recoverExpandState() {
        int rowIndex = 0;
        while (rowIndex < this.getRowCount()) {
            Group group;
            TreePath path;
            if ((path = this.getPathForRow(rowIndex++)).getPathCount() != 2 || !this.expandGroupMap.containsKey((group = (Group)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()).getIndex())) continue;
            this.expandPath(path);
        }
    }

    protected DefaultMutableTreeNode findTreeNode(MsnFriend friend) {
        Enumeration<TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Enumeration<TreeNode> e1 = node.children();
            while (e1.hasMoreElements()) {
                DefaultMutableTreeNode fnode = (DefaultMutableTreeNode)e1.nextElement();
                if (!fnode.getUserObject().equals(friend)) continue;
                return fnode;
            }
        }
        return null;
    }

    protected int insertPreferredIndex(DefaultMutableTreeNode groupNode, MsnFriend toInsert, DefaultMutableTreeNode toAdd) {
        int index = 0;
        Enumeration<TreeNode> e = groupNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            MsnFriend friend = (MsnFriend)node.getUserObject();
            if (this.comparator.compare(friend, toInsert) > 0) {
                groupNode.insert(toAdd, index);
                return index;
            }
            ++index;
        }
        groupNode.add(toAdd);
        return index;
    }

    void createNewSession(MsnFriend friend) {
        if (friend.getStatus() == "FLN") {
            return;
        }
        String loginName = friend.getLoginName();
        ChatDialog cd = (ChatDialog)this.dialogMap.get(loginName);
        if (cd != null) {
            cd.show();
            cd.requestFocus();
            return;
        }
        cd = new ChatDialog((Frame)this.main, this.msnm, loginName, this.me);
        cd.setIconImage(this.chatIcon);
        cd.addWindowListener(new DisposeAdapter());
        this.dialogMap.put(loginName, cd);
        cd.show();
        try {
            this.msnm.doCall(loginName);
        }
        catch (IOException e) {
            cd.dispose();
        }
    }

    protected void createNewSession(SwitchboardSession ss, final MsnFriend friend, final MimeMessage msg) {
        String loginName = friend.getLoginName();
        ChatDialog chat = null;
        chat = (ChatDialog)this.dialogMap.get(loginName);
        if (chat == null) {
            chat = new ChatDialog((Frame)this.main, this.msnm, ss, this.me);
            chat.setIconImage(this.chatIcon);
            chat.addWindowListener(new DisposeAdapter());
            this.dialogMap.put(loginName, chat);
        } else {
            chat.setSession(ss);
        }
        this.sessionMap.put(ss.getSessionId(), chat);
        final ChatDialog fChat = chat;
        chat.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                fChat.appendMessage(friend, msg);
                fChat.removeComponentListener(this);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fChat.show();
                fChat.requestFocus();
            }
        });
    }

    public MsnFriend getSelectedFriend() {
        TreePath path = this.getSelectionPath();
        if (path == null || path.getPathCount() != 3) {
            return null;
        }
        Object o = path.getLastPathComponent();
        if (o instanceof DefaultMutableTreeNode) {
            o = ((DefaultMutableTreeNode)o).getUserObject();
        }
        if (o instanceof MsnFriend) {
            return (MsnFriend)o;
        }
        return null;
    }

    public Group getSelectedGroup() {
        TreePath path = this.getSelectionPath();
        if (path == null || path.getPathCount() != 2) {
            return null;
        }
        Object o = path.getLastPathComponent();
        if (o instanceof DefaultMutableTreeNode) {
            o = ((DefaultMutableTreeNode)o).getUserObject();
        }
        if (o instanceof Group) {
            return (Group)o;
        }
        return null;
    }

    public void setMyStatus(String mode) {
        MsnFriend me = (MsnFriend)this.root.getUserObject();
        me.setStatus(mode);
        this.repaint();
    }

    public void toggleOfflineView() {
        this.setOfflineView(!this.offView);
    }

    public void setOfflineView(boolean offView) {
        this.offView = offView;
        LocalCopy lc = this.main.getMessenger().getLocalCopy();
        lc.setProperty("View.buddy.offline", String.valueOf(offView));
        lc.storeInformation();
        if (this.msnm.isLoggedIn() && this.isVisible()) {
            this.syncAllUsers();
        }
    }

    public void setBuddyView(int mode) {
        this.renderer.setBuddyView(mode);
        this.comparator.setBuddyView(mode);
        if (this.msnm.isLoggedIn()) {
            this.syncAllUsers();
        }
    }

    public void updateAllDialogs() {
        Enumeration e = this.dialogMap.elements();
        while (e.hasMoreElements()) {
            ChatDialog cd = (ChatDialog)e.nextElement();
            SwingUtilities.updateComponentTreeUI(cd);
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Point p = dge.getDragOrigin();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            return;
        }
        Object o = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (o instanceof MsnFriend) {
            MsnFriend friend = (MsnFriend)o;
            this.dragStartGroup = friend.getGroupIndex();
            String ln = friend.getLoginName();
            StringSelection t = new StringSelection(ln);
            this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, t, this);
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        Point p = e.getLocation();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            return;
        }
        Object o = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        int groupIndex = -1;
        if (o instanceof MsnFriend) {
            MsnFriend f = (MsnFriend)o;
            groupIndex = f == this.me ? -1 : f.getGroupIndex();
        } else if (o instanceof Group) {
            Group g = (Group)o;
            groupIndex = g.getIndexInt();
        }
        if (this.dragStartGroup == groupIndex) {
            groupIndex = -1;
            e.rejectDrag();
        }
        this.renderer.setDraggingGroup(groupIndex);
        if (this.oldDraggingIndex != groupIndex) {
            this.oldDraggingIndex = groupIndex;
            this.repaint();
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
        this.oldDraggingIndex = -1;
        this.renderer.setDraggingGroup(-1);
        this.repaint();
    }

    public void drop(DropTargetDropEvent e) {
        Point p = e.getLocation();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            return;
        }
        this.oldDraggingIndex = -1;
        this.renderer.setDraggingGroup(-1);
        this.repaint();
        Object o = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        int groupIndex = -1;
        if (o instanceof MsnFriend) {
            groupIndex = ((MsnFriend)o).getGroupIndex();
        } else if (o instanceof Group) {
            groupIndex = ((Group)o).getIndexInt();
        }
        if (this.dragStartGroup == groupIndex) {
            return;
        }
        try {
            String loginName = (String)e.getTransferable().getTransferData(DataFlavor.stringFlavor);
            e.acceptDrop(2);
            e.getDropTargetContext().dropComplete(true);
            BuddyList list = this.msnm.getBuddyGroup().getForwardList();
            MsnFriend friend = list.get(loginName);
            friend.setGroupIndex(groupIndex);
            this.nonUpdateCount = 2;
            this.msnm.moveGroupAsFriend(friend, this.dragStartGroup, groupIndex);
            DefaultMutableTreeNode oldGroup = this.findGroupNode(new Integer(this.dragStartGroup));
            DefaultMutableTreeNode newGroup = this.findGroupNode(new Integer(groupIndex));
            DefaultMutableTreeNode nodeFriend = this.findTreeNode(friend);
            oldGroup.remove(nodeFriend);
            this.insertPreferredIndex(newGroup, friend, nodeFriend);
            this.model.reload(oldGroup);
            this.model.reload(newGroup);
        }
        catch (Exception ex) {
            e.rejectDrop();
        }
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.backImage != null) {
            JViewport view = (JViewport)this.getParent();
            Point p = view.getViewPosition();
            int w = view.getWidth();
            int h = view.getHeight();
            int iw = this.backImage.getWidth(null);
            int ih = this.backImage.getHeight(null);
            g.drawImage(this.backImage, w - iw + p.x, h - ih + p.y, null);
        }
        super.paintComponent(g);
    }

    static /* synthetic */ boolean access$1100(BuddyTree x0) {
        return x0.offView;
    }

    private class DisposeAdapter
    extends WindowAdapter {
        private DisposeAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            ChatDialog cd = (ChatDialog)e.getSource();
            SwitchboardSession ss = cd.getSession();
            if (ss != null) {
                BuddyTree.this.sessionMap.remove(ss.getSessionId());
                try {
                    ss.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            cd.close();
            BuddyTree.this.dialogMap.remove(cd.getTitle());
        }
    }

    private class Listener
    extends MsnAdapter {
        private Listener() {
        }

        public void renameNotify(MsnFriend i) {
            if (i == null) {
                JOptionPane.showMessageDialog(BuddyTree.this, Msg.get("err.209"), Msg.get("title.alarm"), 0);
                return;
            }
            if (i.getLoginName().equals(BuddyTree.this.me.getLoginName())) {
                BuddyTree.this.me.setFriendlyName(i.getFriendlyName());
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Listener.access$600(this.this$1).syncAllUsers();
                    }
                });
            }
        }

        public void loginComplete(MsnFriend owner) {
            SwingUtilities.invokeLater(new Runnable(this, owner){
                private final /* synthetic */ MsnFriend val$owner;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$owner = val$owner;
                }

                public void run() {
                    Listener.access$600(this.this$1).start(this.val$owner);
                    BuddyTree.access$400((BuddyTree)Listener.access$600((Listener)this.this$1)).menuBar.enableLogin();
                }
            });
        }

        private void refreshGroupNode() {
            Enumeration<TreeNode> e = BuddyTree.this.root.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                BuddyTree.this.model.reload(node);
            }
        }

        public void listOnline(MsnFriend friend) {
            SwingUtilities.invokeLater(new Runnable(this, friend){
                private final /* synthetic */ MsnFriend val$friend;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$friend = val$friend;
                }

                public void run() {
                    DefaultMutableTreeNode node = Listener.access$600(this.this$1).findTreeNode(this.val$friend);
                    if (node == null) {
                        node = new DefaultMutableTreeNode(this.val$friend);
                        Listener.access$600(this.this$1).insertPreferredIndex(Listener.access$600(this.this$1).findGroupNode(this.val$friend.getGroupIndex()), this.val$friend, node);
                    } else {
                        MsnFriend old = (MsnFriend)node.getUserObject();
                        Integer oldGroupIndex = old.getGroupIndex();
                        node.setUserObject(this.val$friend);
                        DefaultMutableTreeNode oldGroup = Listener.access$600(this.this$1).findGroupNode(oldGroupIndex);
                        DefaultMutableTreeNode newGroup = Listener.access$600(this.this$1).findGroupNode(this.val$friend.getGroupIndex());
                        oldGroup.remove(node);
                        Listener.access$600(this.this$1).insertPreferredIndex(newGroup, this.val$friend, node);
                        BuddyTree.access$700(Listener.access$600(this.this$1)).reload(oldGroup);
                        BuddyTree.access$700(Listener.access$600(this.this$1)).reload(newGroup);
                    }
                    BuddyTree.access$700(Listener.access$600(this.this$1)).reload(node);
                    Listener.access$800(this.this$1);
                }
            });
        }

        public void instantMessageReceived(SwitchboardSession ss, MsnFriend friend, MimeMessage msg) {
            ChatDialog chat = (ChatDialog)BuddyTree.this.sessionMap.get(ss.getSessionId());
            if (chat != null) {
                chat.appendMessage(friend, msg);
            } else {
                BuddyTree.this.createNewSession(ss, friend, msg);
            }
        }

        public void userOnline(MsnFriend friend) {
            String loginName = friend.getLoginName();
            String formatStatus = UserStatusBox.getFormattedUserStatus(friend.getStatus());
            String formatName = friend.getFormattedFriendlyName();
            SwingUtilities.invokeLater(new Runnable(this, friend, loginName, formatStatus, formatName){
                private final /* synthetic */ MsnFriend val$friend;
                private final /* synthetic */ String val$loginName;
                private final /* synthetic */ String val$formatStatus;
                private final /* synthetic */ String val$formatName;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$friend = val$friend;
                    this.val$loginName = val$loginName;
                    this.val$formatStatus = val$formatStatus;
                    this.val$formatName = val$formatName;
                }

                public void run() {
                    DefaultMutableTreeNode node = Listener.access$600(this.this$1).findTreeNode(this.val$friend);
                    BuddyList list = BuddyTree.access$1000(Listener.access$600(this.this$1)).getBuddyGroup().getForwardList();
                    MsnFriend old = list.get(this.val$loginName);
                    if (node != null && !"FLN".equals(old.getOldStatus())) {
                        BuddyTree.access$400(Listener.access$600(this.this$1)).addEvent(this.val$formatStatus + " " + this.val$formatName + " (" + this.val$loginName + ")", this.val$friend);
                        old.setFriendlyName(this.val$friend.getFriendlyName());
                        old.setStatus(this.val$friend.getStatus());
                        node.setUserObject(old);
                        node.removeFromParent();
                        DefaultMutableTreeNode group = Listener.access$600(this.this$1).findGroupNode(old.getGroupIndex());
                        Listener.access$600(this.this$1).insertPreferredIndex(group, old, node);
                        BuddyTree.access$700(Listener.access$600(this.this$1)).reload(group);
                    } else {
                        if (node == null) {
                            this.val$friend.setGroupIndex(old.getGroupIndex());
                            node = new DefaultMutableTreeNode(this.val$friend);
                            DefaultMutableTreeNode group = Listener.access$600(this.this$1).findGroupNode(this.val$friend.getGroupIndex());
                            Listener.access$600(this.this$1).insertPreferredIndex(group, this.val$friend, node);
                            BuddyTree.access$700(Listener.access$600(this.this$1)).reload(group);
                        } else {
                            node.removeFromParent();
                            node.setUserObject(this.val$friend);
                            DefaultMutableTreeNode group = Listener.access$600(this.this$1).findGroupNode(this.val$friend.getGroupIndex());
                            Listener.access$600(this.this$1).insertPreferredIndex(group, this.val$friend, node);
                            BuddyTree.access$700(Listener.access$600(this.this$1)).reload(group);
                        }
                        Listener.access$800(this.this$1);
                        BuddyTree.access$400(Listener.access$600(this.this$1)).addEvent(Msg.get("event.login", this.val$loginName, this.val$formatName), this.val$friend);
                        MusicBox.play("Login");
                    }
                }
            });
        }

        public void userOffline(String loginName) {
            SwingUtilities.invokeLater(new Runnable(this, loginName){
                private final /* synthetic */ String val$loginName;
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                    this.val$loginName = val$loginName;
                }

                public void run() {
                    DefaultMutableTreeNode node = Listener.access$600(this.this$1).findTreeNode(new MsnFriend(this.val$loginName, ""));
                    if (node != null) {
                        MsnFriend friend = (MsnFriend)node.getUserObject();
                        friend.setStatus("FLN");
                        if (BuddyTree.access$1100(Listener.access$600(this.this$1))) {
                            node.removeFromParent();
                            DefaultMutableTreeNode group = Listener.access$600(this.this$1).findGroupNode(friend.getGroupIndex());
                            Listener.access$600(this.this$1).insertPreferredIndex(group, friend, node);
                            BuddyTree.access$700(Listener.access$600(this.this$1)).reload(group);
                        } else {
                            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                            parent.remove(node);
                            BuddyTree.access$700(Listener.access$600(this.this$1)).reload(parent);
                            Listener.access$800(this.this$1);
                        }
                        BuddyTree.access$400(Listener.access$600(this.this$1)).addEvent(Msg.get("event.logout.2", friend.getLoginName(), friend.getFormattedFriendlyName()), null);
                    } else {
                        BuddyTree.access$400(Listener.access$600(this.this$1)).addEvent(Msg.get("event.logout.1", this.val$loginName), null);
                    }
                }
            });
            ChatDialog cd = (ChatDialog)BuddyTree.this.dialogMap.get(loginName);
            if (cd != null) {
                cd.userOffline();
            }
        }

        public void whoJoinSession(SwitchboardSession ss, MsnFriend join) {
            String loginName = join.getLoginName();
            if (ss.getSessionId() == null) {
                return;
            }
            ChatDialog cd = null;
            cd = (ChatDialog)BuddyTree.this.sessionMap.get(ss.getSessionId());
            if (cd == null) {
                cd = (ChatDialog)BuddyTree.this.dialogMap.get(loginName);
                if (cd == null) {
                    return;
                }
                BuddyTree.this.sessionMap.put(ss.getSessionId(), cd);
                cd.setSession(ss);
            }
            if (ss.getFriendCount() > 1) {
                MimeMessage msg = new MimeMessage();
                msg.setMessage(Msg.get("chatdlg.msg.whojoin", loginName, join.getFormattedFriendlyName()));
                cd.appendMessage(msg);
            }
        }

        public void whoPartSession(SwitchboardSession ss, MsnFriend part) {
            String loginName = part.getLoginName();
            ChatDialog cd = null;
            cd = (ChatDialog)BuddyTree.this.sessionMap.get(ss.getSessionId());
            if (cd != null) {
                MimeMessage msg = new MimeMessage();
                if (System.currentTimeMillis() - 300000L > cd.getLastMessagingTime()) {
                    msg.setMessage(Msg.get("chatdlg.msg.timeout", "5"));
                } else {
                    msg.setMessage(Msg.get("chatdlg.msg.whopart", loginName, part.getFormattedFriendlyName()));
                }
                cd.appendMessage(msg);
            }
        }

        public void switchboardSessionStarted(SwitchboardSession ss) {
            ss.setTimeout(0);
            MsnFriend friend = ss.getMsnFriend();
            if (friend != null) {
                SwingUtilities.invokeLater(new Runnable(this, friend){
                    private final /* synthetic */ MsnFriend val$friend;
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$friend = val$friend;
                    }

                    public void run() {
                        BuddyTree.access$400(Listener.access$600(this.this$1)).addEvent(Msg.get("event.ring", this.val$friend.getLoginName(), this.val$friend.getFormattedFriendlyName()), this.val$friend);
                    }
                });
            }
        }

        public void switchboardSessionEnded(SwitchboardSession ss) {
            ChatDialog cd = (ChatDialog)BuddyTree.this.sessionMap.remove(ss.getSessionId());
            if (cd != null) {
                cd.sessionClosed();
                return;
            }
        }

        public void switchboardSessionAbandon(SwitchboardSession ss, String targetName) {
            ChatDialog cd = (ChatDialog)BuddyTree.this.dialogMap.get(targetName);
            if (cd != null) {
                cd.sessionClosed();
                MimeMessage msg = new MimeMessage();
                msg.setMessage(Msg.get("chatdlg.msg.ssclose"));
                cd.appendMessage(msg);
            }
        }

        public void buddyListModified() {
            BuddyTree.this.nonUpdateCount--;
            if (BuddyTree.this.nonUpdateCount < 0) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Listener.access$600(this.this$1).syncAllUsers();
                    }
                });
            }
            if (BuddyTree.this.nonUpdateCount < 0) {
                BuddyTree.this.nonUpdateCount = 0;
            }
        }

        public void progressTyping(SwitchboardSession ss, MsnFriend friend, String view) {
            String sid = ss.getSessionId();
            ChatDialog cd = (ChatDialog)BuddyTree.this.sessionMap.get(sid);
            if (cd != null) {
                cd.whoTyping(view);
            }
        }

        public void filePosted(SwitchboardSession ss, int cookie, String filename, int filesize) {
            String sid = ss.getSessionId();
            ChatDialog cd = (ChatDialog)BuddyTree.this.sessionMap.get(sid);
            if (cd == null) {
                cd = new ChatDialog((Frame)BuddyTree.this.main, BuddyTree.this.msnm, ss, BuddyTree.this.me);
                cd.setIconImage(BuddyTree.this.chatIcon);
                cd.addWindowListener(new DisposeAdapter());
                BuddyTree.this.sessionMap.put(sid, cd);
                String ln = ss.getMsnFriend().getLoginName();
                if (!BuddyTree.this.dialogMap.containsKey(ln)) {
                    BuddyTree.this.dialogMap.put(ln, cd);
                }
                cd.show();
                cd.requestFocus();
            }
            cd.addFileItem(new FileItem(ss, cookie, filename, filesize));
        }

        public void allListUpdated() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Listener.access$600(this.this$1).syncAllUsers();
                }
            });
        }

        public void logoutNotify() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    BuddyTree.access$400(Listener.access$600(this.this$1)).logout();
                }
            });
        }

        static /* synthetic */ BuddyTree access$600(Listener x0) {
            return x0.BuddyTree.this;
        }

        static /* synthetic */ void access$800(Listener x0) {
            x0.refreshGroupNode();
        }
    }

    private class BuddyMouseAdapter
    extends MouseAdapter {
        private BuddyMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            TreePath rootPath = null;
            rootPath = BuddyTree.this.getPathForLocation(e.getX(), e.getY());
            if (rootPath != null) {
                int row = BuddyTree.this.getRowForPath(rootPath);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootPath.getLastPathComponent();
                if (node == BuddyTree.this.root) {
                    JPopupMenu pop = ((BuddyTree)BuddyTree.this).main.menuBar.getStatusPopupMenu();
                    pop.show(BuddyTree.this, e.getX(), e.getY());
                    return;
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            DefaultMutableTreeNode o;
            Object uo;
            if (BuddyTree.this.getRowForLocation(e.getX(), e.getY()) == -1) {
                return;
            }
            TreePath path = BuddyTree.this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            if (e.getClickCount() > 1 && (uo = (o = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof MsnFriend && o != BuddyTree.this.root) {
                MsnFriend friend = (MsnFriend)uo;
                BuddyTree.this.createNewSession(friend);
            }
        }
    }
}

