/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import java.util.Date;

public class Log {
    public static int EMERGENCY;
    public static int ALERT;
    public static int CRITICAL;
    public static int ERROR;
    public static int WARNING;
    public static int NOTICE;
    public static int INFO;
    public static int DEBUG;
    public static int DB0;
    public static int DB1;
    public static int DB2;
    public static int DB3;
    public static int MAXLEVEL;
    private static PrintStream log;
    private static int logLevel;
    private static boolean useTimeStamps;

    public static boolean logIt(String string, int n) {
        return n <= logLevel;
    }

    public static void log(String string, int n, String string2) {
        Log.log(string, n, string2, null);
    }

    public static void log(String string, String string2) {
        Log.log(string, DB2, string2, null);
    }

    public static void log(String string) {
        Log.log(null, DB2, string, null);
    }

    public static synchronized void log(String string, int n, String string2, Exception exception) {
        if (string == null) {
            string = "";
        }
        if (!Log.logIt(string, n)) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        String string3 = Log.getPriorityString(n);
        if (log != null) {
            Log.printDateIfNecessary();
            log.println(String.valueOf(string3) + ": " + string + " " + string2);
            if (exception != null) {
                log.println(exception.getMessage());
                exception.printStackTrace(log);
            }
            log.flush();
        }
        if (log != System.err && System.err != null && n < INFO) {
            System.err.println(String.valueOf(string3) + ": " + string + " " + string2);
            System.err.flush();
        }
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static Exception setLogLevel(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n < 1 || n > MAXLEVEL) {
                return new NumberFormatException("Value out of range.");
            }
            logLevel = n;
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return numberFormatException;
        }
    }

    public static Exception setLogLevel(int n) {
        if (n < 1 || n > MAXLEVEL) {
            return new NumberFormatException("Value out of range.");
        }
        logLevel = n;
        return null;
    }

    private static String getPriorityString(int n) {
        if (n == EMERGENCY) {
            return "EMER";
        }
        if (n == ALERT) {
            return "ALRT";
        }
        if (n == CRITICAL) {
            return "CRIT";
        }
        if (n == ERROR) {
            return "EROR";
        }
        if (n == WARNING) {
            return "WARN";
        }
        if (n == NOTICE) {
            return "NOTC";
        }
        if (n == INFO) {
            return "INFO";
        }
        return "DBG" + (n - DEBUG);
    }

    private static void printDateIfNecessary() {
        if (useTimeStamps) {
            String string = new Date().toString();
            String string2 = string.substring(26);
            string2 = String.valueOf(string2) + " " + string.substring(4, 19);
            log.print("[" + string2 + "]");
        }
    }

    static {
        ALERT = 1;
        CRITICAL = 2;
        ERROR = 3;
        WARNING = 4;
        NOTICE = 5;
        INFO = 6;
        DEBUG = 7;
        DB0 = 7;
        DB1 = 8;
        DB2 = 9;
        DB3 = 10;
        MAXLEVEL = 10;
        log = System.out;
        logLevel = INFO;
    }
}

