/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;
import snac.SnacNicknameWinfo;

public class SnacIcbmMissedCall
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int channel;
    public SnacNicknameWinfo nickWinfo;
    public int numMissed;
    public int reason;

    public SnacIcbmMissedCall(int n, SnacNicknameWinfo snacNicknameWinfo, int n2, int n3) {
        this.channel = n;
        this.nickWinfo = snacNicknameWinfo;
        this.numMissed = n2;
        this.reason = n3;
    }

    SnacIcbmMissedCall(DataInputStream dataInputStream) throws IOException {
        this.channel = dataInputStream.readUnsignedShort();
        this.nickWinfo = new SnacNicknameWinfo(dataInputStream);
        this.numMissed = dataInputStream.readUnsignedShort();
        this.reason = dataInputStream.readUnsignedShort();
        if (this.reason < 1 || this.reason > 8) {
            throw new IOException("reason bad value " + this.reason);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.channel);
        this.nickWinfo.write(dataOutputStream);
        dataOutputStream.writeShort(this.numMissed);
        if (this.reason < 1 || this.reason > 8) {
            throw new IOException("reason bad value " + this.reason);
        }
        dataOutputStream.writeShort(this.reason);
    }
}

