/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.ListenerConstants;
import snac.ReqID;
import snac.SNACHeader;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public abstract class SnacHandler
implements ListenerConstants {
    private static final String MODULE = "SNAC";
    DispatcherListener dispatcher;

    public static String stringFromByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = new String(byArray);
        return string.trim();
    }

    public abstract void decodeSNAC(FLAPSock var1, SNACHeader var2, DataInputStream var3, Listener var4, Object var5, Vector var6) throws IOException;

    public String toString() {
        return this.getClass().getName();
    }

    public void decodeSnacError(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.INFO, "got ERROR SNAC");
        int n = dataInputStream.readUnsignedShort();
        TLV tLV = new TLV();
        tLV.readTlvVector(dataInputStream, dataInputStream.available());
        int n2 = this.initHandledState();
        if (listener != null) {
            n2 = this.updateHandledState(n2, listener.snacError(fLAPSock, object, sNACHeader.reqID, n2, n, tLV));
        }
        int n3 = 0;
        while (vector != null && n3 < vector.size() && this.proceed(n2)) {
            Listener listener2 = (Listener)vector.elementAt(n3);
            if (listener2 != listener) {
                n2 = this.updateHandledState(n2, listener2.snacError(fLAPSock, object, sNACHeader.reqID, n2, n, tLV));
            }
            ++n3;
        }
    }

    public void snacError(FLAPSock fLAPSock, Listener listener, Object object, ReqID reqID, int n, TLV tLV) {
        Log.log(MODULE, Log.INFO, "writing snacError SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            tLV.writeTlvVector(outputBuffer);
            this.dispatcher.queueOutput(fLAPSock, listener, object, 1, 1, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("SnacHandler", "got IOException in snacError " + iOException.getMessage());
            return;
        }
    }

    public int initHandledState() {
        return 0;
    }

    public int updateHandledState(int n, int n2) {
        if (n == 2 || n2 == 2) {
            return 2;
        }
        if (n == 1 || n2 == 1) {
            return 1;
        }
        return 0;
    }

    public boolean proceed(int n) {
        return n != 2;
    }
}

