/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.AdvertHostListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.SnacTlvBlock;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class AdvertHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public AdvertHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(5, 1, this);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRequestAds(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got advertRequestAds SNAC");
        AdvertHostListener advertHostListener = (AdvertHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (advertHostListener != null) {
                        n2 = this.updateHandledState(n2, advertHostListener.advertRequestAds(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdvertHostListener advertHostListener2;
                    if ((advertHostListener2 = (AdvertHostListener)vector.elementAt(n)) != advertHostListener) {
                        n2 = this.updateHandledState(n2, advertHostListener2.advertRequestAds(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Advert", "got IOException in advertRequestAds " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void ads(FLAPSock fLAPSock, AdvertHostListener advertHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing advertAds SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacTlvBlock)vector.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, advertHostListener, object, 5, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Advert", "got IOException in advertAds " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeRequestAds(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Advert", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

