/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Image;
import java.awt.Toolkit;
import snac.SnacConstants;
import snac.TLV;
import util.Log;

public class Ad
implements SnacConstants {
    public int id = -1;
    public int spot = -1;
    public String mimeType;
    public byte[] data;
    public String url;
    public String text;
    public int expireSecs = -1;
    public int maxDisplayCount = -1;
    public int minDisplaySecs = -1;
    public int idleDelay = -1;
    public boolean isAnimated = false;
    public int widthHint = -1;
    public int heightHint = -1;
    public int activeDelay = -1;
    Image image;
    public boolean isGood = false;
    public long createTime = -1L;
    public int timesDisplayed;
    public long msDisplayed;

    Ad(TLV tLV, long l) {
        this.createTime = l;
        try {
            this.isGood = false;
            this.id = tLV.getTlvDataAsS32(1);
            this.spot = tLV.getTlvDataAsS32(2);
            this.mimeType = tLV.getTlvDataAsString(3);
            this.data = tLV.getTlvData(4);
            this.url = tLV.getTlvDataAsString(5);
            this.text = tLV.getTlvDataAsString(6);
            if (tLV.tlvTypePresent(7)) {
                this.expireSecs = tLV.getTlvDataAsS32(7);
            }
            if (tLV.tlvTypePresent(8)) {
                this.maxDisplayCount = tLV.getTlvDataAsU16(8);
            }
            if (tLV.tlvTypePresent(9)) {
                this.minDisplaySecs = tLV.getTlvDataAsU16(9);
            }
            this.isAnimated = false;
            if (tLV.tlvTypePresent(11)) {
                this.idleDelay = tLV.getTlvDataAsU16(11);
                this.isAnimated = true;
            } else if (tLV.tlvTypePresent(10)) {
                this.idleDelay = tLV.getTlvDataAsU16(10);
            }
            if (tLV.tlvTypePresent(14)) {
                this.widthHint = tLV.getTlvDataAsU16(14);
            }
            if (tLV.tlvTypePresent(15)) {
                this.heightHint = tLV.getTlvDataAsU16(15);
            }
            if (tLV.tlvTypePresent(16)) {
                this.activeDelay = tLV.getTlvDataAsU16(16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.isGood = false;
            numberFormatException.printStackTrace();
            Log.log("bad ad " + this);
        }
        if (this.mimeType != null && this.url != null && (this.data != null || this.text != null)) {
            this.isGood = true;
        }
    }

    Ad() {
        this.createTime = System.currentTimeMillis();
    }

    public String toString() {
        int n = -1;
        if (this.data != null) {
            n = this.data.length;
        }
        return "Ad " + this.id + " " + this.spot + " " + this.mimeType + " " + n + " " + this.url + " " + this.text + " " + this.expireSecs + " " + this.maxDisplayCount + " " + this.minDisplaySecs + " " + this.isAnimated + " " + this.idleDelay;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = Toolkit.getDefaultToolkit().createImage(this.data);
        }
        return this.image;
    }
}

