/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.FolderInfo;
import component.SetupUI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import main.Oscar;
import uiutil.ImageContainer;
import uiutil.ImagePanel;
import uiutil.PropertySheet;
import uiutil.UIPack;

public class Folders
extends ImagePanel
implements MouseListener {
    private int TAB_HEIGHT = 19;
    private int FOLDER_TOP = 16;
    private int TAB_WIDTH = 80;
    private int BASELINE = 14;
    private int WIDTH = 330;
    private int HEIGHT = 280;
    private int LEFT_INDENT = 3;
    private int BORDER = 3;
    private int FG;
    private int BG = 1;
    private Graphics offscreen;
    private Image backdrop;
    private FolderInfo[] folders;
    private Image[][] tabs;
    private Image tabForeground;
    private Image tabBackground;
    private int showing;
    private Font backgroundFont;
    private Font foregroundFont;
    private CardLayout cardLayout;
    private SetupUI setupUI;

    public Folders(SetupUI setupUI, UIPack uIPack, FolderInfo[] folderInfoArray, int n) {
        this.folders = folderInfoArray;
        this.showing = n;
        this.setupUI = setupUI;
        this.addMouseListener(this);
        this.tabs = new Image[folderInfoArray.length][2];
        this.tabForeground = Oscar.images.getImage(uIPack, "Tabfg", this, true);
        this.tabBackground = Oscar.images.getImage(uIPack, "Tabbg", this, true);
        this.setSize(this.WIDTH, this.HEIGHT);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        int n2 = 0;
        while (n2 < folderInfoArray.length) {
            PropertySheet propertySheet = folderInfoArray[n2].getPropertySheet();
            if (propertySheet != null) {
                this.add(folderInfoArray[n2].getFolderName(), propertySheet);
                propertySheet.setBounds(this.BORDER, this.TAB_HEIGHT, this.WIDTH - 2 * this.BORDER, this.HEIGHT - this.BORDER - this.TAB_HEIGHT);
            }
            ++n2;
        }
        if (n < 0 || n >= folderInfoArray.length) {
            n = 0;
        }
    }

    public void addNotify() {
        super.addNotify();
        int n = 0;
        while (n < this.folders.length) {
            this.tabs[n][this.FG] = this.makeTab(this.folders[n].getFolderName(), this.getForegroundFont(), this.tabForeground);
            this.tabs[n][this.BG] = this.makeTab(this.folders[n].getFolderName(), this.getBackgroundFont(), this.tabBackground);
            ++n;
        }
    }

    public boolean changed() {
        boolean bl = false;
        int n = 0;
        while (n < this.folders.length) {
            PropertySheet propertySheet = this.folders[n].getPropertySheet();
            if (propertySheet != null && propertySheet.changed()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void createBackdrop() {
        Dimension dimension = this.getSize();
        Image image = ((ImageContainer)((Object)this.getParent())).getBackground(0, 0, this.WIDTH, this.FOLDER_TOP);
        this.backdrop = this.createImage(dimension.width, dimension.height);
        this.offscreen = this.backdrop.getGraphics();
        this.offscreen.drawImage(image, 0, 0, this);
        this.offscreen.setColor(Color.black);
        this.offscreen.drawLine(0, this.FOLDER_TOP, 0, dimension.height - 1);
        this.offscreen.drawLine(this.WIDTH - 1, this.FOLDER_TOP, this.WIDTH - 1, dimension.height - 1);
        this.offscreen.drawLine(0, dimension.height - 1, this.WIDTH - 1, dimension.height - 1);
        this.offscreen.drawLine(0, this.FOLDER_TOP, this.WIDTH - 1, this.FOLDER_TOP);
        this.offscreen.setColor(Color.white);
        this.offscreen.drawLine(1, this.FOLDER_TOP + 1, 1, dimension.height - 2);
        this.offscreen.drawLine(2, this.FOLDER_TOP + 2, 2, dimension.height - 3);
        this.offscreen.drawLine(1, this.FOLDER_TOP + 1, this.WIDTH - 2, this.FOLDER_TOP + 1);
        this.offscreen.drawLine(2, this.FOLDER_TOP + 2, this.WIDTH - 3, this.FOLDER_TOP + 2);
        this.offscreen.setColor(Color.black);
        this.offscreen.drawLine(this.WIDTH - 2, this.FOLDER_TOP + 1, this.WIDTH - 2, dimension.height - 2);
        this.offscreen.drawLine(this.WIDTH - 3, this.FOLDER_TOP + 2, this.WIDTH - 3, dimension.height - 3);
        this.offscreen.drawLine(1, dimension.height - 2, this.WIDTH - 2, dimension.height - 2);
        this.offscreen.drawLine(2, dimension.height - 3, this.WIDTH - 3, dimension.height - 3);
        this.paintTabs();
        image = null;
    }

    private Font getBackgroundFont() {
        if (this.backgroundFont == null) {
            Font font = this.getFont();
            this.backgroundFont = new Font(font.getName(), 0, font.getSize());
        }
        return this.backgroundFont;
    }

    private Font getForegroundFont() {
        if (this.foregroundFont == null) {
            Font font = this.getFont();
            this.foregroundFont = new Font(font.getName(), 1, font.getSize());
        }
        return this.foregroundFont;
    }

    public void selectCard(int n) {
        PropertySheet propertySheet;
        if (n == -1) {
            n = this.showing;
        }
        if ((propertySheet = this.folders[n].getPropertySheet()) == null) {
            this.folders[n].propertySheet = propertySheet = this.folders[n].getModule().getPropertySheet(this.folders[n], this.setupUI);
            this.add(this.folders[n].getFolderName(), propertySheet);
            propertySheet.setBounds(this.BORDER, this.TAB_HEIGHT, this.WIDTH - 2 * this.BORDER, this.HEIGHT - this.BORDER - this.TAB_HEIGHT);
        }
        this.cardLayout.show(this, this.folders[n].getFolderName());
    }

    public boolean help() {
        return this.folders[this.showing].getPropertySheet().help();
    }

    public Insets getInsets() {
        return new Insets(this.TAB_HEIGHT, this.BORDER, this.BORDER, this.BORDER);
    }

    private Image makeTab(String string, Font font, Image image) {
        Image image2 = this.createImage(this.TAB_WIDTH, this.TAB_HEIGHT);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, 0, 0, this);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString(string, (this.TAB_WIDTH - fontMetrics.stringWidth(string)) / 2, this.BASELINE);
        graphics.dispose();
        graphics = null;
        return image2;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getY() < this.TAB_HEIGHT) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.folders.length) {
                if (this.folders[n2].isEnabled()) {
                    if (mouseEvent.getX() > this.LEFT_INDENT + n * this.TAB_WIDTH - 1 && mouseEvent.getX() < this.LEFT_INDENT + (n + 1) * this.TAB_WIDTH - 1) break;
                    ++n;
                }
                ++n2;
            }
            if (n2 >= 0 && n2 < this.folders.length && n2 != this.showing) {
                this.showing = n2;
                this.paintTabs();
                this.selectCard(n2);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.backdrop == null) {
            this.createBackdrop();
        }
        if (this.backdrop != null) {
            graphics.drawImage(this.backdrop, 0, 0, this);
        }
    }

    public void doLayout() {
        this.backdrop = null;
        this.repaint();
    }

    public void paintTabs() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.folders.length) {
            if (this.folders[n2].isEnabled()) {
                if (n2 == this.showing) {
                    this.offscreen.drawImage(this.tabs[n2][this.FG], this.LEFT_INDENT + n * this.TAB_WIDTH, 0, this);
                } else {
                    this.offscreen.drawImage(this.tabs[n2][this.BG], this.LEFT_INDENT + n * this.TAB_WIDTH, 0, this);
                }
                ++n;
            }
            ++n2;
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void removeNotify() {
        this.removeAll();
        this.offscreen = null;
        this.backdrop = null;
        if (this.folders != null && this.tabs != null) {
            int n = 0;
            while (n < this.folders.length) {
                if (this.tabs[n] != null) {
                    this.tabs[n][this.FG] = null;
                    this.tabs[n][this.BG] = null;
                    this.folders[n] = null;
                }
                ++n;
            }
            this.tabs = null;
            this.folders = null;
        }
        this.tabForeground = null;
        this.tabBackground = null;
        this.backgroundFont = null;
        this.foregroundFont = null;
        this.cardLayout = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void reset() {
        int n = 0;
        while (n < this.folders.length) {
            PropertySheet propertySheet = this.folders[n].getPropertySheet();
            if (propertySheet != null) {
                propertySheet.setValues();
            }
            ++n;
        }
    }

    public boolean save() {
        boolean bl = false;
        int n = 0;
        while (n < this.folders.length) {
            PropertySheet propertySheet = this.folders[n].getPropertySheet();
            if (propertySheet != null && propertySheet.changed()) {
                bl = propertySheet.save();
            }
            ++n;
        }
        return bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void showTab(int n) {
        this.folders[n].setEnabled(true);
        if (this.foregroundFont != null) {
            this.paintTabs();
        }
    }

    public void showTab(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.folders.length) {
            if (string.equals(this.folders[n].getFolderName())) {
                this.showTab(n);
                return;
            }
            ++n;
        }
    }

    public void hideTab(int n) {
        this.folders[n].setEnabled(false);
        if (this.foregroundFont != null) {
            this.createBackdrop();
        }
    }

    public void hideTab(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < this.folders.length) {
            if (string.equals(this.folders[n].getFolderName())) {
                this.hideTab(n);
                return;
            }
            ++n;
        }
    }
}

