/*
 * Decompiled with CFR 0.152.
 */
package component;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import main.Oscar;
import uiutil.ACheckbox;
import uiutil.ACheckboxGroup;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import uiutil.UrlViewer;

public class BrowserProps
extends PropertySheet
implements ActionListener,
ItemListener,
KeyListener {
    private Frame frame;
    private ChangeListener changeListener;
    private ACheckbox defaultCheck;
    private ACheckbox specifCheck;
    private ACheckboxGroup cbgroup;
    private TextField browserName;
    private Button openBrowser;
    private boolean changed = false;

    public BrowserProps(Frame frame, ChangeListener changeListener) {
        this.frame = frame;
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout(5, 5));
        this.add("West", new Spacer());
        this.add("East", new Spacer());
        this.add("North", new Spacer());
        this.cbgroup = new ACheckboxGroup();
        this.defaultCheck = new ACheckbox("The default browser", this.cbgroup, true, 5);
        this.defaultCheck.addItemListener(this);
        this.specifCheck = new ACheckbox("The browser specified below:", this.cbgroup, false, 5);
        this.specifCheck.addItemListener(this);
        this.browserName = new TextField(20);
        this.browserName.addKeyListener(this);
        this.browserName.addActionListener(this);
        this.openBrowser = new Button("Browse");
        this.openBrowser.addActionListener(this);
        this.browserName.setEnabled(false);
        this.openBrowser.setEnabled(false);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(this.browserName);
        transparentPanel.add(this.openBrowser);
        TransparentPanel transparentPanel2 = new TransparentPanel(new GridLayout(6, 1));
        this.add("Center", transparentPanel2);
        transparentPanel2.add(new Label("View Web documents with:"));
        TransparentPanel transparentPanel3 = new TransparentPanel(new GridLayout(2, 1));
        transparentPanel3.add(this.defaultCheck);
        transparentPanel3.add(this.specifCheck);
        transparentPanel2.add(transparentPanel3);
        transparentPanel2.add(transparentPanel);
        this.setValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.specifCheck) {
            this.browserName.setEnabled(true);
            this.openBrowser.setEnabled(true);
        } else if (itemEvent.getSource() == this.defaultCheck) {
            this.browserName.setEnabled(false);
            this.openBrowser.setEnabled(false);
        }
        this.setChanged(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openBrowser) {
            FileDialog fileDialog = new FileDialog(this.frame, "Open File", 0);
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() != null) {
                String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                ((TextComponent)this.browserName).setText(string);
            }
        } else if (actionEvent.getSource() == this.browserName) {
            this.browserName.transferFocus();
        }
        this.setChanged(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Browser Help", "You should specify the location of a browser only if the `default' option doesn't work. To specify a browser to use, click on the second radio button and enter the browser's full path in the text field. You can use the 'Browse' button to help you locate the full path to the browser you want to use.");
        return true;
    }

    public void removeNotify() {
        this.removeAll();
        this.frame = null;
        this.defaultCheck = null;
        this.specifCheck = null;
        this.cbgroup = null;
        this.browserName = null;
        this.openBrowser = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        if (this.defaultCheck.getState()) {
            Oscar.config.setValue("Browser", "default");
            UrlViewer.defaultBrowser = null;
        }
        if (this.specifCheck.getState()) {
            String string = this.browserName.getText();
            if (string != null) {
                string = string.replace(File.separatorChar, '/');
            }
            Oscar.config.setValue("Browser", string);
            UrlViewer.defaultBrowser = this.browserName.getText();
        }
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        String string = Oscar.config.getValueDefault("Browser", "default");
        if (string == null || string.equals("default")) {
            this.cbgroup.setCurrent(this.defaultCheck);
            this.browserName.setEnabled(false);
            this.openBrowser.setEnabled(false);
            UrlViewer.defaultBrowser = null;
        } else {
            string = string.replace('/', File.separatorChar);
            this.cbgroup.setCurrent(this.specifCheck);
            ((TextComponent)this.browserName).setText(string);
            this.browserName.setEnabled(true);
            this.openBrowser.setEnabled(true);
            UrlViewer.defaultBrowser = string;
        }
        this.setChanged(false);
    }
}

