/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHTunnel;
import mindbright.ssh.SSHTxChannel;

public class SSHConnectChannel
extends SSHTxChannel {
    SSHChannelController controller;
    Hashtable hostMap;

    public SSHConnectChannel(SSHChannelController sSHChannelController) {
        super(null, -2);
        this.controller = sSHChannelController;
        this.hostMap = new Hashtable();
    }

    public synchronized void addHostMapPermanent(String string, String string2, int n) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(string2);
        vector.addElement(new Integer(n));
        vector.addElement(new Boolean(true));
        this.hostMap.put(string, vector);
    }

    public synchronized void addHostMapTemporary(String string, String string2, int n) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(string2);
        vector.addElement(new Integer(n));
        vector.addElement(new Boolean(false));
        this.hostMap.put(string, vector);
    }

    public synchronized void delHostMap(String string) {
        this.hostMap.remove(string);
    }

    public synchronized Vector getHostMap(String string) {
        Vector vector = (Vector)this.hostMap.get(string);
        if (vector != null && !((Boolean)vector.elementAt(2)).booleanValue()) {
            this.delHostMap(string);
        }
        return vector;
    }

    int displayNumber(String string) {
        int n;
        if (string == null || string.equals("") || (n = string.indexOf(58)) == -1) {
            return 0;
        }
        int n2 = string.indexOf(46, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (Exception exception) {
            int n3 = 0;
            return n3;
        }
    }

    String displayHost(String string) {
        int n;
        if (string == null || string.equals("") || string.charAt(0) == ':' || string.indexOf("unix:") == 0 || (n = string.indexOf(58)) == -1) {
            return "localhost";
        }
        return string.substring(0, n);
    }

    public void serviceLoop() throws Exception {
        while (true) {
            SSHPduOutputStream sSHPduOutputStream;
            int n;
            String string;
            Object object;
            SSHPduInputStream sSHPduInputStream = (SSHPduInputStream)this.queue.getFirst();
            int n2 = sSHPduInputStream.readInt();
            if (sSHPduInputStream.type == 27) {
                if (!this.controller.sshAsClient().user.wantX11Forward()) {
                    this.controller.alert("Something is fishy with the server, unsolicited X11 forward!");
                    throw new Exception("Something is fishy with the server, unsolicited X11 forward!");
                }
                object = this.controller.sshAsClient().user.getDisplay();
                string = this.displayHost((String)object);
                n = 6000 + this.displayNumber((String)object);
            } else {
                string = sSHPduInputStream.readString();
                n = sSHPduInputStream.readInt();
            }
            String string2 = this.controller.haveHostInFwdOpen() ? sSHPduInputStream.readString() : "unknown (origin-option not used)";
            object = this.getHostMap(string);
            if (object != null) {
                string = (String)((Vector)object).elementAt(0);
                n = (Integer)((Vector)object).elementAt(1);
            }
            try {
                Socket socket = new Socket(string, n);
                int n3 = this.controller.newChannelId();
                SSHTunnel sSHTunnel = new SSHTunnel(socket, n3, n2, this.controller);
                this.controller.addTunnel(sSHTunnel);
                sSHTunnel.setRemoteDesc(string2);
                sSHPduOutputStream = new SSHPduOutputStream(21, this.controller.sndCipher);
                sSHPduOutputStream.writeInt(n2);
                sSHPduOutputStream.writeInt(n3);
                SSH.log("Port open (" + string2 + ") : " + string + ": " + n + " (#" + n2 + ")" + " new: " + n3);
                this.controller.transmit(sSHPduOutputStream);
                sSHTunnel.start();
                continue;
            }
            catch (IOException iOException) {
                sSHPduOutputStream = new SSHPduOutputStream(22, this.controller.sndCipher);
                sSHPduOutputStream.writeInt(n2);
                this.controller.alert("Failed port open (" + string2 + ") : " + string + ": " + n + " (#" + n2 + ")");
                this.controller.transmit(sSHPduOutputStream);
                continue;
            }
            break;
        }
    }
}

