/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHPduInputStream;
import mindbright.ssh.SSHPduOutputStream;
import mindbright.ssh.SSHPduQueue;
import mindbright.ssh.SSHSocketFactory;
import mindbright.ssh.SSHSocketTunnel;

public class SSHSocketImpl
extends SocketImpl {
    public static final int SO_TIMEOUT = 4102;
    protected SSHSocketFactory factory;
    SSHClient client;
    SSHSocketTunnel tunnel;
    SSHPduQueue cnQueue;
    boolean isClosed;

    protected SSHSocketImpl() {
        this.localport = -1;
    }

    protected void setFactory(SSHSocketFactory sSHSocketFactory) {
        this.factory = sSHSocketFactory;
    }

    protected void create(boolean bl) {
    }

    protected void create(SSHClient sSHClient, boolean bl) throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        this.client = sSHClient;
        sSHClient.addRef();
        if (bl) {
            this.cnQueue = sSHClient.controller.getCnQueue();
        } else {
            this.tunnel = new SSHSocketTunnel(sSHClient.controller, this);
            this.tunnel.setLocalAddress(inetAddress);
        }
    }

    protected void connect(String string, int n) throws IOException {
        try {
            this.address = InetAddress.getByName(string);
        }
        catch (Exception exception) {
            this.address = InetAddress.getLocalHost();
        }
        this.tunnel.connect(string, n);
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.connect(inetAddress.getHostAddress(), n);
    }

    protected void bind(InetAddress inetAddress, int n) throws IOException {
        this.localport = n;
    }

    protected void listen(int n) throws IOException {
        this.cnQueue.setMaxDepth(n);
    }

    protected void accept(SocketImpl socketImpl) throws IOException {
        SSHSocketImpl sSHSocketImpl = (SSHSocketImpl)socketImpl;
        SSHPduInputStream sSHPduInputStream = (SSHPduInputStream)this.cnQueue.getFirst();
        if (sSHPduInputStream == null) {
            throw new IOException("Socket closed");
        }
        int n = sSHPduInputStream.readInt();
        sSHSocketImpl.tunnel.setRemoteChannelId(n);
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(21, this.client.controller.sndCipher);
        sSHPduOutputStream.writeInt(n);
        sSHPduOutputStream.writeInt(sSHSocketImpl.tunnel.channelId);
        this.client.controller.transmit(sSHPduOutputStream);
        this.client.controller.addTunnel(sSHSocketImpl.tunnel);
    }

    protected InputStream getInputStream() throws IOException {
        return this.tunnel.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.tunnel.out;
    }

    protected int available() throws IOException {
        return this.tunnel.available();
    }

    protected void close() throws IOException {
        if (this.localport == -1) {
            if (this.tunnel != null && !this.tunnel.terminated()) {
                this.tunnel.close();
            }
        } else {
            this.factory.closePseudoUser(this.client, this);
        }
    }

    protected void finalize() throws IOException {
        if (!this.isClosed) {
            this.close();
        }
    }

    public void setOption(int n, Object object) throws SocketException {
        throw new SocketException("Not implemented");
    }

    public Object getOption(int n) throws SocketException {
        throw new SocketException("Not implemented");
    }

    protected InetAddress getInetAddress() {
        return this.address;
    }

    protected int getPort() {
        return this.port;
    }

    protected int getLocalPort() {
        return this.localport;
    }
}

