/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.util.AWTConvenience;

public final class SSHProxyDialog {
    private static Dialog proxyDialog = null;
    private static Choice choicePrxType;
    private static Checkbox cbNeedAuth;
    private static TextField textPrxHost;
    private static TextField textPrxPort;
    private static TextField textPrxUser;
    private static TextField textPrxPasswd;
    private static String[] prxTypes;
    private static SSHPropertyHandler propsHandler;

    public static void show(String string, Frame frame, SSHPropertyHandler sSHPropertyHandler) {
        Object object;
        Object object2;
        propsHandler = sSHPropertyHandler;
        if (proxyDialog == null) {
            prxTypes = SSH.getProxyTypes();
            proxyDialog = new Dialog(frame, string, true);
            object2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            proxyDialog.setLayout((LayoutManager)object2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            gridBagConstraints.gridy = 0;
            object = new Label("Proxy type:");
            gridBagConstraints.gridwidth = 2;
            ((GridBagLayout)object2).setConstraints((Component)object, gridBagConstraints);
            proxyDialog.add((Component)object);
            choicePrxType = new Choice();
            int n = 0;
            while (n < prxTypes.length) {
                choicePrxType.add(prxTypes[n]);
                ++n;
            }
            ((GridBagLayout)object2).setConstraints(choicePrxType, gridBagConstraints);
            proxyDialog.add(choicePrxType);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getSource() == choicePrxType) {
                        textPrxPort.setText(String.valueOf(SSH.defaultProxyPorts[SSH.getProxyType(choicePrxType.getSelectedItem())]));
                    }
                    SSHProxyDialog.updateFromType();
                }
            };
            choicePrxType.addItemListener(itemListener);
            gridBagConstraints.gridy = 1;
            object = new Label("Server:");
            ((GridBagLayout)object2).setConstraints((Component)object, gridBagConstraints);
            proxyDialog.add((Component)object);
            gridBagConstraints.gridwidth = 4;
            textPrxHost = new TextField("", 16);
            ((GridBagLayout)object2).setConstraints(textPrxHost, gridBagConstraints);
            proxyDialog.add(textPrxHost);
            gridBagConstraints.gridwidth = 1;
            object = new Label("Port:");
            ((GridBagLayout)object2).setConstraints((Component)object, gridBagConstraints);
            proxyDialog.add((Component)object);
            textPrxPort = new TextField("", 4);
            ((GridBagLayout)object2).setConstraints(textPrxPort, gridBagConstraints);
            proxyDialog.add(textPrxPort);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            object = new Label("Username:");
            ((GridBagLayout)object2).setConstraints((Component)object, gridBagConstraints);
            proxyDialog.add((Component)object);
            textPrxUser = new TextField("", 10);
            ((GridBagLayout)object2).setConstraints(textPrxUser, gridBagConstraints);
            proxyDialog.add(textPrxUser);
            object = new Label("Password:");
            ((GridBagLayout)object2).setConstraints((Component)object, gridBagConstraints);
            proxyDialog.add((Component)object);
            textPrxPasswd = new TextField("", 10);
            textPrxPasswd.setEchoChar('*');
            ((GridBagLayout)object2).setConstraints(textPrxPasswd, gridBagConstraints);
            proxyDialog.add(textPrxPasswd);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 4;
            cbNeedAuth = new Checkbox("Need authentication");
            ((GridBagLayout)object2).setConstraints(cbNeedAuth, gridBagConstraints);
            proxyDialog.add(cbNeedAuth);
            cbNeedAuth.addItemListener(itemListener);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("OK");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = choicePrxType.getSelectedItem();
                        propsHandler.setProperty("proxytype", string);
                        if (!"none".equalsIgnoreCase(string)) {
                            propsHandler.setProperty("proxyhost", textPrxHost.getText());
                            propsHandler.setProperty("proxyport", textPrxPort.getText());
                        }
                        if (cbNeedAuth.getState()) {
                            propsHandler.setProperty("proxyuser", textPrxUser.getText());
                            propsHandler.setProperty("prxpassword", textPrxPasswd.getText());
                        } else if ("socks4".equals(string)) {
                            propsHandler.setProperty("proxyuser", textPrxUser.getText());
                        }
                        ((Component)proxyDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(proxyDialog));
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)object2).setConstraints(panel, gridBagConstraints);
            proxyDialog.add(panel);
            proxyDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(proxyDialog);
            proxyDialog.setResizable(true);
            proxyDialog.pack();
        }
        proxyDialog.setTitle(string);
        object = propsHandler.getProperty("proxytype");
        choicePrxType.select((String)object);
        object2 = propsHandler.getProperty("proxyuser");
        boolean bl = object2 != null && ((String)object2).trim().length() > 0;
        cbNeedAuth.setState(bl);
        textPrxHost.setText(propsHandler.getProperty("proxyhost"));
        textPrxPort.setText(propsHandler.getProperty("proxyport"));
        textPrxUser.setText(propsHandler.getProperty("proxyuser"));
        SSHProxyDialog.updateFromType();
        AWTConvenience.placeDialog(proxyDialog);
        ((Component)proxyDialog).setVisible(true);
    }

    private static void updateFromType() {
        boolean bl = false;
        boolean bl2 = false;
        String string = choicePrxType.getSelectedItem();
        int n = 0;
        try {
            n = SSH.getProxyType(string);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    bl2 = true;
                }
                case 2: {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        textPrxHost.setEnabled(bl);
        textPrxPort.setEnabled(bl);
        cbNeedAuth.setEnabled(bl2);
        if (!bl2) {
            cbNeedAuth.setState(false);
        }
        boolean bl3 = cbNeedAuth.getState();
        textPrxUser.setEnabled(bl3);
        textPrxPasswd.setEnabled(bl3);
        if (bl) {
            if (textPrxHost.getText().length() == 0) {
                textPrxHost.setText(propsHandler.getProperty("proxyhost"));
            }
            if (textPrxPort.getText().length() == 0) {
                textPrxPort.setText(propsHandler.getProperty("proxyport"));
            }
        } else {
            textPrxHost.setText("");
            textPrxPort.setText("");
        }
        if (bl3) {
            if (textPrxUser.getText().length() == 0) {
                textPrxUser.setText(propsHandler.getProperty("proxyuser"));
            }
        } else {
            textPrxUser.setText("");
            textPrxPasswd.setText("");
        }
        if (n == 2) {
            textPrxUser.setEnabled(true);
            String string2 = propsHandler.getProperty("proxyuser");
            if (textPrxUser.getText().length() == 0) {
                if (string2 == null) {
                    string2 = "anonymous";
                }
                textPrxUser.setText(string2);
            }
        }
        if (bl) {
            textPrxHost.requestFocus();
        }
    }
}

