/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import mindbright.security.KeyPair;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHCommandShell;
import mindbright.ssh.SSHInteractiveClient;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHStdIO;
import mindbright.terminal.TerminalDefProps;
import mindbright.terminal.TerminalWin;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public final class SSHCommandShellImpl
implements SSHCommandShell {
    static Toolkit toolkit = Toolkit.getDefaultToolkit();
    SSHStdIO stdio;
    int escapeIdx;
    String escapeString = "~$";

    public void setStdIO(SSHStdIO sSHStdIO) {
        this.stdio = sSHStdIO;
    }

    public String getNextArg(String string) {
        int n = string.indexOf(32);
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String[] makeArgv(String string) {
        String[] stringArray = new String[32];
        int n = 0;
        while (string != null) {
            stringArray[n++] = this.getNextArg(string);
            int n2 = string.indexOf(32);
            if (n2 > -1) {
                string = string.substring(n2);
                string = string.trim();
                continue;
            }
            string = null;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public void doHelp() {
        this.stdio.println("The following commands are available:");
        this.stdio.println("");
        this.stdio.println("go                                    Start SSH-session with current settings.");
        this.stdio.println("quit                                  Quit program (or disconnect if connected).");
        this.stdio.println("add <l|r> [/<plug>/]<port>:<host>:<port>  (see below).");
        this.stdio.println("del l <local-host>:<listen-port>|*    Delete local forward (* = all).");
        this.stdio.println("del r <listen-port>|*                 Delete remote forward (* = all).");
        this.stdio.println("list [ssh | term]                     Lists ssh- and/or terminal-settings.");
        this.stdio.println("set [<parameter> <value>]             Set value of a ssh-parameter.");
        this.stdio.println("tset [<parameter> <value>]            Set value of a terminal-parameter.");
        this.stdio.println("key [<bits>]                          Generate RSA key-pair (of length <bits>).");
        this.stdio.println("help                                  Display this list, but you knew that :-).");
        this.stdio.println("");
        this.stdio.println("(do 'set' without arguments to list parameter-usage)");
        this.stdio.println("");
        this.stdio.println("Examples of adding a remote/local tunnel:");
        this.stdio.println("> add r 4711:www.foo.com:80           Adds a remote tunnel at port 4711 back to");
        this.stdio.println("                                      www.foo.com port 80 without a plugin,");
        this.stdio.println("                                      i.e. default tunneling behaviour.");
        this.stdio.println("> add l /ftp/4711:ftp.bar.com:21      Adds a local tunnel going to ftp.bar.com");
        this.stdio.println("                                      port 21 using the ftp protocol-plugin to");
        this.stdio.println("                                      handle protocol specific needs.");
        this.stdio.println("");
        this.stdio.println("NOTE: The first character of the command can be used instead of the full word.");
        this.stdio.println("");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public void doHelpSet() {
        block3: {
            int n;
            block2: {
                this.stdio.println("SSH-parameters:");
                this.stdio.println("");
                n = 0;
                if (!true) break block2;
                SSHInteractiveClient cfr_ignored_0 = this.stdio.client;
                if (n >= SSHPropertyHandler.defaultPropDesc.length) break block3;
            }
            do {
                SSHInteractiveClient cfr_ignored_1 = this.stdio.client;
                SSHInteractiveClient cfr_ignored_2 = this.stdio.client;
                SSHInteractiveClient cfr_ignored_3 = this.stdio.client;
                SSHInteractiveClient cfr_ignored_4 = this.stdio.client;
                this.stdio.println(SSHPropertyHandler.defaultPropDesc[n][0] + "\t: " + SSHPropertyHandler.defaultPropDesc[n][2]);
                ++n;
                SSHInteractiveClient cfr_ignored_5 = this.stdio.client;
            } while (n < SSHPropertyHandler.defaultPropDesc.length);
        }
        this.stdio.println("(to see possible parameter-values use 'list')");
    }

    public void doHelpTSet() {
        this.stdio.println("Terminal-parameters:");
        this.stdio.println("");
        int n = 0;
        while (n < TerminalDefProps.defaultPropDesc.length) {
            this.stdio.println(TerminalDefProps.defaultPropDesc[n][0] + "\t: " + TerminalDefProps.defaultPropDesc[n][2]);
            ++n;
        }
        this.stdio.println("(to see possible parameter-values use 'list')");
    }

    public void doAdd(String[] stringArray) {
        if (stringArray.length < 3 || !stringArray[1].equals("l") && !stringArray[1].equals("r")) {
            this.doHelp();
        } else {
            try {
                if (stringArray[1].equals("l")) {
                    this.stdio.client.propsHandler.setProperty("local" + this.stdio.client.localForwards.size(), stringArray[2]);
                } else {
                    this.stdio.client.propsHandler.setProperty("remote" + this.stdio.client.remoteForwards.size(), stringArray[2]);
                }
            }
            catch (Exception exception) {
                this.doHelp();
            }
        }
    }

    public void doDel(String[] stringArray) {
        if (stringArray.length < 3 || !stringArray[1].equals("l") && !stringArray[1].equals("r")) {
            this.doHelp();
        } else {
            try {
                int n;
                if (stringArray[2].equals("*")) {
                    n = -1;
                }
                if (stringArray[1].equals("l")) {
                    int n2 = stringArray[2].indexOf(58);
                    String string = stringArray[2].substring(0, n2);
                    n = Integer.parseInt(stringArray[2].substring(n2 + 1));
                    this.stdio.client.delLocalPortForward(string, n);
                } else {
                    n = Integer.parseInt(stringArray[2]);
                    this.stdio.client.delRemotePortForward(n);
                }
            }
            catch (Exception exception) {
                this.doHelp();
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public void doListSSH() {
        String[] stringArray;
        int n;
        block15: {
            block14: {
                this.stdio.println("");
                if (this.stdio.term != null) {
                    this.stdio.term.setAttribute(1, true);
                }
                this.stdio.println("SSH settings:");
                if (this.stdio.term != null) {
                    this.stdio.term.setAttribute(1, false);
                }
                n = 0;
                if (!true) break block14;
                SSHInteractiveClient cfr_ignored_0 = this.stdio.client;
                if (n >= SSHPropertyHandler.defaultPropDesc.length) break block15;
            }
            do {
                SSHInteractiveClient cfr_ignored_1 = this.stdio.client;
                SSHInteractiveClient cfr_ignored_2 = this.stdio.client;
                stringArray = SSHPropertyHandler.defaultPropDesc[n][0];
                String string = this.stdio.client.propsHandler.getProperty((String)stringArray);
                SSHInteractiveClient cfr_ignored_3 = this.stdio.client;
                SSHInteractiveClient cfr_ignored_4 = this.stdio.client;
                this.stdio.println((String)stringArray + "\t: " + (string.equals("") ? "<not set>" : string) + " " + SSHPropertyHandler.defaultPropDesc[n][3]);
                ++n;
                SSHInteractiveClient cfr_ignored_5 = this.stdio.client;
            } while (n < SSHPropertyHandler.defaultPropDesc.length);
        }
        this.stdio.println("");
        this.stdio.println("local tunnels:");
        n = 0;
        while (n < this.stdio.client.localForwards.size()) {
            stringArray = (SSHClient.LocalForward)this.stdio.client.localForwards.elementAt(n);
            this.stdio.println("\tlocal:  " + stringArray.localPort + "\tremote: " + stringArray.remoteHost + "/" + stringArray.remotePort + " (plugin: " + stringArray.plugin + ")");
            ++n;
        }
        if (n == 0) {
            this.stdio.println("\t<none>");
        }
        this.stdio.println("remote tunnels:");
        n = 0;
        while (n < this.stdio.client.remoteForwards.size()) {
            stringArray = (SSHClient.RemoteForward)this.stdio.client.remoteForwards.elementAt(n);
            this.stdio.println("\tremote: " + stringArray.remotePort + "\tlocal:  " + stringArray.localHost + "/" + stringArray.localPort + " (plugin: " + stringArray.plugin + ")");
            ++n;
        }
        if (n == 0) {
            this.stdio.println("\t<none>");
        }
        this.stdio.println("");
        if (this.stdio.client.isOpened()) {
            if (this.stdio.term != null) {
                this.stdio.term.setAttribute(1, true);
            }
            this.stdio.println("Currently active tunnels:");
            if (this.stdio.term != null) {
                this.stdio.term.setAttribute(1, false);
            }
            if ((stringArray = this.stdio.controller.listTunnels()).length == 0) {
                this.stdio.print("\t<none>");
            } else {
                n = 0;
                while (n < stringArray.length) {
                    this.stdio.println("\t" + stringArray[n]);
                    ++n;
                }
            }
            this.stdio.println("");
        }
    }

    public void doListTerm() {
        this.stdio.println("");
        if (this.stdio.term != null) {
            TerminalWin terminalWin = this.stdio.term;
            this.stdio.term.setAttribute(1, true);
            this.stdio.println("Terminal settings:");
            this.stdio.term.setAttribute(1, false);
            int n = 0;
            while (n < TerminalDefProps.defaultPropDesc.length) {
                String string = TerminalDefProps.defaultPropDesc[n][0];
                this.stdio.println(string + "\t: " + terminalWin.getProperty(string) + " " + TerminalDefProps.defaultPropDesc[n][3]);
                ++n;
            }
            this.stdio.println("");
        }
    }

    public void doSet(String[] stringArray) {
        if (stringArray.length < 3) {
            this.doHelpSet();
        } else {
            try {
                String string = stringArray[1];
                String string2 = stringArray[2];
                this.stdio.client.propsHandler.setProperty(string, string2);
            }
            catch (Exception exception) {
                this.stdio.println(exception.getMessage());
                this.stdio.println("(use 'set' without parameters to get help on available parameters)");
            }
        }
    }

    public void doTSet(String[] stringArray) {
        if (stringArray.length < 3) {
            this.doHelpTSet();
        } else {
            String string = stringArray[1];
            String string2 = stringArray[2];
            TerminalWin terminalWin = null;
            if (this.stdio.term instanceof TerminalWin) {
                terminalWin = this.stdio.term;
            }
            if (terminalWin != null) {
                try {
                    terminalWin.setProperty(string, string2);
                }
                catch (Exception exception) {
                    this.stdio.println(exception.getMessage());
                    this.stdio.println("(use 'tset' without parameters to get help on available parameters)");
                }
            } else {
                this.stdio.println("Can't set terminal-parameters in dumb-console mode.");
            }
        }
    }

    public void doGenKey(String[] stringArray) {
        int n = 1024;
        this.stdio.println("");
        if (stringArray.length > 1) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                this.stdio.println("(invalid <bits>, using default 1024)");
            }
        }
        try {
            String string;
            this.stdio.println("The key-pair will be stored in a file with the name you enter.");
            this.stdio.println("Files are stored in '" + this.stdio.client.propsHandler.getSSHHomeDir() + "' if no path is given.");
            this.stdio.println("(note: the public key will also be stored in a file with ext. '.pub')");
            String string2 = this.stdio.promptLine("Filename to save identity in: ", "", false);
            if (!string2.startsWith(File.separator)) {
                string2 = this.stdio.client.propsHandler.getSSHHomeDir() + string2;
            }
            while (!(string = this.stdio.promptLine("Password to protect private key: ", "", true)).equals(this.stdio.promptLine("Password again: ", "", true))) {
            }
            String string3 = this.stdio.promptLine("Comment to store in key-files: ", "", false);
            this.stdio.print("Generating identity of length " + n + "...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            KeyPair keyPair = SSH.generateRSAKeyPair(n, SSH.secureRandom());
            this.stdio.println("done");
            String string4 = SSH.generateKeyFiles(keyPair, string2, string, string3);
            this.stdio.setSelection(string4);
            this.stdio.selectionAvailable(true);
        }
        catch (Exception exception) {
            this.stdio.println("An error occured while generating key...");
        }
        this.stdio.println("");
    }

    public boolean doCommandShell() {
        boolean bl = true;
        this.stdio.println("");
        this.stdio.println("...entering local command-shell (type 'h' for help).");
        this.stdio.println("");
        try {
            boolean bl2 = true;
            while (bl2) {
                String string = this.stdio.promptLine("mindterm> ", null, false);
                string = string.toLowerCase();
                if ((string = string.trim()).equals("")) continue;
                String[] stringArray = this.makeArgv(string);
                String string2 = stringArray[0];
                if (string2.equals("l") || string2.equals("list")) {
                    if (stringArray.length > 1) {
                        if (stringArray[1].equals("ssh") || stringArray[1].equals("term")) {
                            if (stringArray[1].equals("ssh")) {
                                this.doListSSH();
                            } else {
                                this.doListTerm();
                            }
                            this.stdio.println("(permitted values are in parentheses on the right)");
                            this.stdio.println("");
                            continue;
                        }
                        this.stdio.println("usage: 'list [ssh | term]'");
                        continue;
                    }
                    this.doListSSH();
                    this.doListTerm();
                    this.stdio.println("(permitted values are in parentheses on the right)");
                    this.stdio.println("");
                    continue;
                }
                if (string2.equals("a") || string2.equals("add")) {
                    this.doAdd(stringArray);
                    continue;
                }
                if (string2.equals("d") || string2.equals("del")) {
                    this.doDel(stringArray);
                    continue;
                }
                if (string2.equals("s") || string2.equals("set")) {
                    this.doSet(stringArray);
                    continue;
                }
                if (string2.equals("t") || string2.equals("ts") || string2.equals("tset")) {
                    this.doTSet(stringArray);
                    continue;
                }
                if (string2.equals("help") || string2.equals("?") || string2.equals("h")) {
                    this.doHelp();
                    continue;
                }
                if (string2.equals("go") || string2.equals("g")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (string2.equals("key")) {
                    this.doGenKey(stringArray);
                    continue;
                }
                if (string2.equals("q") || string2.equals("quit")) {
                    bl = false;
                    bl2 = false;
                    continue;
                }
                this.doHelp();
            }
        }
        catch (SSHStdIO.CtrlDPressedException ctrlDPressedException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void launchCommandShell() {
        try {
            PrivilegeManager.enablePrivilege("UniversalThreadGroupAccess");
            PrivilegeManager.enablePrivilege("UniversalThreadAccess");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            // empty catch block
        }
        new Thread(SSH.getThreadGroup(), new Runnable(){

            public void run() {
                SSHCommandShellImpl.this.stdio.isConnected = false;
                if (!SSHCommandShellImpl.this.doCommandShell()) {
                    SSHCommandShellImpl.this.stdio.controller.sendDisconnect("exit");
                } else {
                    SSHCommandShellImpl.this.stdio.isConnected = true;
                    try {
                        SSHCommandShellImpl.this.stdio.typedChar('\f');
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    public boolean escapeSequenceTyped(char c) {
        this.escapeIdx = c == this.escapeString.charAt(this.escapeIdx) ? ++this.escapeIdx : 0;
        if (this.escapeIdx == this.escapeString.length()) {
            this.escapeIdx = 0;
            return true;
        }
        return false;
    }

    public String escapeString() {
        return this.escapeString;
    }
}

