/*
 * Decompiled with CFR 0.152.
 */
package mindbright.security;

import java.io.IOException;
import java.math.BigInteger;
import mindbright.security.KeyPair;
import mindbright.security.RSAPrivateKey;
import mindbright.security.RSAPublicKey;
import mindbright.security.SecureRandom;

public class RSACipher {
    public KeyPair keys;

    public RSACipher(KeyPair keyPair) {
        this.keys = keyPair;
    }

    public BigInteger doPublic(BigInteger bigInteger) {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)this.keys.getPublic();
        BigInteger bigInteger2 = bigInteger.modPow(rSAPublicKey.getE(), rSAPublicKey.getN());
        return bigInteger2;
    }

    public BigInteger doPrivate(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.keys.getPrivate();
        BigInteger bigInteger3 = rSAPrivateKey.getP().subtract(bigInteger2);
        bigInteger3 = rSAPrivateKey.getD().mod(bigInteger3);
        BigInteger bigInteger4 = rSAPrivateKey.getQ().subtract(bigInteger2);
        bigInteger4 = rSAPrivateKey.getD().mod(bigInteger4);
        BigInteger bigInteger5 = bigInteger.mod(rSAPrivateKey.getP());
        bigInteger5 = bigInteger5.modPow(bigInteger3, rSAPrivateKey.getP());
        BigInteger bigInteger6 = bigInteger.mod(rSAPrivateKey.getQ());
        if (bigInteger5.compareTo(bigInteger6 = bigInteger6.modPow(bigInteger4, rSAPrivateKey.getQ())) == 0) {
            return bigInteger5;
        }
        BigInteger bigInteger7 = bigInteger6.subtract(bigInteger5).mod(rSAPrivateKey.getQ());
        bigInteger7 = bigInteger7.multiply(rSAPrivateKey.getU());
        bigInteger7 = bigInteger7.mod(rSAPrivateKey.getQ());
        BigInteger bigInteger8 = bigInteger7.multiply(rSAPrivateKey.getP());
        bigInteger8 = bigInteger8.add(bigInteger5);
        return bigInteger8;
    }

    public static BigInteger stripPad(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] != 2) {
            throw new IOException("Invalid strip-data");
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 0) break;
            ++n;
        }
        if (n == byArray.length) {
            throw new IOException("Invalid strip-data");
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return new BigInteger(byArray2);
    }

    public static BigInteger doPad(BigInteger bigInteger, int n, SecureRandom secureRandom) throws IOException {
        int n2;
        int n3 = (bigInteger.bitLength() + 7) / 8;
        if (n3 > (n2 = (n + 7) / 8) - 3) {
            throw new IOException("rsaPad: Input too long to pad");
        }
        byte[] byArray = new byte[n2 - n3 - 3 + 1];
        secureRandom.nextBytes(byArray);
        byArray[0] = 0;
        int n4 = 1;
        while (n4 < n2 - n3 - 3 + 1) {
            if (byArray[n4] == 0) {
                byArray[n4] = 23;
            }
            ++n4;
        }
        BigInteger bigInteger2 = new BigInteger(byArray);
        bigInteger2 = bigInteger2.shiftLeft((n3 + 1) * 8);
        BigInteger bigInteger3 = new BigInteger("2");
        bigInteger3 = bigInteger3.shiftLeft((n2 - 2) * 8);
        bigInteger3 = bigInteger3.or(bigInteger2);
        bigInteger3 = bigInteger3.or(bigInteger);
        return bigInteger3;
    }
}

