/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import javax.servlet.http.HttpServletRequest;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.servlet.HttpSession_Impl;
import net.zerotoaster.httpd.servlet.SessionData;

public abstract class SessionManager
extends Application {
    protected Configuration cnf = null;
    protected LogContext log = null;
    protected long lngSessionTimeout = 0L;
    protected long lngCleanupCycle = 0L;
    private CleanupThread thrdCleaner = null;

    public SessionManager(LogContext log, Configuration cnf) {
        this.log = log;
        this.cnf = cnf;
        this.init0();
    }

    protected abstract void cleanup();

    public HttpSession_Impl createHttpSession(HttpServletRequest req) {
        return new HttpSession_Impl(this.createSession(req));
    }

    public abstract SessionData createSession(HttpServletRequest var1);

    public void dispose() {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        if (this.thrdCleaner != null) {
            this.thrdCleaner.dispose();
        }
        this.cleanup();
    }

    public void forceCleanup() {
        CleanupThread cleanupThread = this.thrdCleaner;
        synchronized (cleanupThread) {
            this.thrdCleaner.notify();
        }
    }

    public HttpSession_Impl getHttpSession(String strID) {
        if (!this.isValid(strID)) {
            return null;
        }
        SessionData sd = this.getSession(strID);
        if (sd == null) {
            return null;
        }
        sd.blnIsNewSession = false;
        sd.lngLastAccessedTime = TimeFactory.getTime();
        return new HttpSession_Impl(sd);
    }

    protected abstract SessionData getSession(String var1);

    public abstract String getStatistics();

    private void init0() {
        this.lngCleanupCycle = this.cnf.lngSrvlSessionCleanupCycle;
        this.lngSessionTimeout = this.cnf.lngSrvlSessionTimeout;
        HttpSession_Impl.SESSION_IDENTIFIER = this.cnf.strSrvlSessionID;
        this.log.write("# Starting session-cleaner");
        try {
            this.thrdCleaner = new CleanupThread(this, this.lngCleanupCycle);
        }
        catch (Throwable t) {
            this.log.write("? While starting session cleaner", t);
            throw new RuntimeException();
        }
        this.log.write("# Session-cleaner started");
    }

    public abstract boolean isValid(String var1);

    public void putHttpSession(HttpSession_Impl hs) {
        SessionData sd = hs._getSessionData();
        this.putSession(sd);
    }

    protected abstract void putSession(SessionData var1);

    public abstract String toString();

    class CleanupThread
    extends Thread {
        /* synthetic */ SessionManager this$0;
        private boolean blnIsRunning = true;
        private long lngWaitTime = 0L;
        private LockObject objLock = new LockObject();

        public CleanupThread(SessionManager this$0, long l) {
            this.this$0 = this$0;
            this.lngWaitTime = l;
            this.blnIsRunning = true;
            this.setName("SessionManager-Cleanup");
            this.setPriority(10);
            this.start();
        }

        public void dispose() {
            this.this$0.log.write("D Disposing SessionManager-Cleanup thread");
            this.blnIsRunning = false;
            this.objLock.lo_notify();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
            this.this$0.log.write("D SessionManager-Cleanup thread disposed");
            this.objLock.dispose();
        }

        public void run() {
            while (this.blnIsRunning) {
                this.objLock.lo_wait(this.lngWaitTime);
                if (!this.blnIsRunning) break;
                this.this$0.cleanup();
            }
        }
    }
}

