/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.servlet.SessionData;
import net.zerotoaster.httpd.servlet.SessionManager;

public class MemorySessionManager
extends SessionManager {
    private Hashtable hshData = new Hashtable();
    private int intSessionCount = 0;

    public MemorySessionManager(LogContext log, Configuration cnf) {
        super(log, cnf);
    }

    protected void cleanup() {
        int intCntCleaned = 0;
        int intCntTotal = 0;
        Hashtable hashtable = this.hshData;
        synchronized (hashtable) {
            this.log.write("# Starting cleanup");
            Enumeration e = this.hshData.elements();
            while (e.hasMoreElements()) {
                ++intCntTotal;
                SessionData sd = (SessionData)e.nextElement();
                if (sd.hshValues != null && sd.isValidSession()) continue;
                this.hshData.remove(sd.strID);
                ++intCntCleaned;
            }
        }
        this.log.write("# Removed " + intCntCleaned + " entries of " + intCntTotal);
    }

    public SessionData createSession(HttpServletRequest req) {
        long lngTime = TimeFactory.getTime();
        SessionData sc = new SessionData();
        sc.blnIsNewSession = true;
        sc.hshValues = new Hashtable();
        sc.lngCreationTime = lngTime;
        sc.lngLastAccessedTime = lngTime;
        sc.lngMaxInactiveInterval = this.lngSessionTimeout;
        sc.strID = "ID" + TimeFactory.createUID();
        return sc;
    }

    protected SessionData getSession(String strID) {
        SessionData sd = null;
        Hashtable hashtable = this.hshData;
        synchronized (hashtable) {
            sd = (SessionData)this.hshData.get(strID);
        }
        return sd;
    }

    public String getStatistics() {
        StringBuffer strb = new StringBuffer();
        strb.append("Entries total: ");
        strb.append(this.hshData.size());
        strb.append(", valid entries: ");
        int intValid = 0;
        Hashtable hashtable = this.hshData;
        synchronized (hashtable) {
            Enumeration e = this.hshData.elements();
            while (e.hasMoreElements()) {
                SessionData sd = (SessionData)e.nextElement();
                if (sd.hshValues == null || !sd.isValidSession()) continue;
                ++intValid;
            }
        }
        strb.append(intValid);
        return strb.toString();
    }

    public boolean isValid(String strID) {
        if (strID == null) {
            return false;
        }
        SessionData sd = null;
        Hashtable hashtable = this.hshData;
        synchronized (hashtable) {
            sd = (SessionData)this.hshData.get(strID);
        }
        return sd != null && sd.isValidSession();
    }

    protected void putSession(SessionData sd) {
        this.hshData.put(sd.strID, sd);
    }

    public String toString() {
        return this.getStatistics();
    }
}

