/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base64;

public class TKEYRecord
extends Record {
    private Name alg;
    private Date timeInception;
    private Date timeExpire;
    private short mode;
    private short error;
    private byte[] key;
    private byte[] other;
    public static final short SERVERASSIGNED = 1;
    public static final short DIFFIEHELLMAN = 2;
    public static final short GSSAPI = 3;
    public static final short RESOLVERASSIGNED = 4;
    public static final short DELETE = 5;

    TKEYRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)249, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.alg = new Name(in);
        this.timeInception = new Date(1000L * (long)in.readInt());
        this.timeExpire = new Date(1000L * (long)in.readInt());
        this.mode = in.readShort();
        this.error = in.readShort();
        int keylen = in.readUnsignedShort();
        if (keylen > 0) {
            this.key = new byte[keylen];
            in.read(this.key);
        } else {
            this.key = null;
        }
        int otherlen = in.readUnsignedShort();
        if (otherlen > 0) {
            this.other = new byte[otherlen];
            in.read(this.other);
        } else {
            this.other = null;
        }
    }

    public TKEYRecord(Name _name, short _dclass, int _ttl, Name _alg, Date _timeInception, Date _timeExpire, short _mode, short _error, byte[] _key, byte[] _other) throws IOException {
        super(_name, (short)249, _dclass, _ttl);
        this.alg = _alg;
        this.timeInception = _timeInception;
        this.timeExpire = _timeExpire;
        this.mode = _mode;
        this.error = _error;
        this.key = _key;
        this.other = _other;
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public short getError() {
        return this.error;
    }

    public byte[] getKey() {
        return this.key;
    }

    public short getMode() {
        return this.mode;
    }

    public byte[] getOther() {
        return this.other;
    }

    public Date getTimeExpire() {
        return this.timeExpire;
    }

    public Date getTimeInception() {
        return this.timeInception;
    }

    protected String modeString() {
        switch (this.mode) {
            case 1: {
                return "SERVERASSIGNED";
            }
            case 2: {
                return "DIFFIEHELLMAN";
            }
            case 3: {
                return "GSSAPRESOLVERASSIGNED";
            }
            case 4: {
                return "RESOLVERASSIGNED";
            }
            case 5: {
                return "DELETE";
            }
        }
        return new Short(this.mode).toString();
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.alg == null) {
            return sb.toString();
        }
        sb.append(this.alg);
        sb.append(" (\n\t");
        sb.append(SIGRecord.formatDate(this.timeInception));
        sb.append(" ");
        sb.append(SIGRecord.formatDate(this.timeExpire));
        sb.append(" ");
        sb.append(this.modeString());
        sb.append(" ");
        sb.append(Rcode.TSIGstring(this.error));
        sb.append("\n");
        if (this.key != null) {
            sb.append(base64.formatString(this.key, 64, "\t", false));
        }
        if (this.other != null) {
            sb.append(base64.formatString(this.other, 64, "\t", false));
        }
        sb.append(" )");
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.alg == null) {
            return;
        }
        this.alg.toWire(out, null);
        out.writeInt((int)(this.timeInception.getTime() / 1000L));
        out.writeInt((int)(this.timeExpire.getTime() / 1000L));
        out.writeShort(this.mode);
        out.writeShort(this.error);
        if (this.key != null) {
            out.writeShort((short)this.key.length);
            out.write(this.key);
        } else {
            out.writeShort(0);
        }
        if (this.other != null) {
            out.writeShort((short)this.other.length);
            out.write(this.other);
        } else {
            out.writeShort(0);
        }
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        throw new IOException("A TKEY should never be converted to canonical");
    }
}

