/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class OPTRecord
extends Record {
    private Hashtable options;

    private OPTRecord() {
    }

    OPTRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)41, _dclass, _ttl);
        if (in == null) {
            return;
        }
        int count = 0;
        if (count < length) {
            this.options = new Hashtable();
        }
        while (count < length) {
            int code = in.readUnsignedShort();
            int len = in.readUnsignedShort();
            byte[] data = new byte[len];
            in.read(data);
            count += 4 + len;
            this.options.put(new Integer(code), data);
        }
    }

    public OPTRecord(short payloadSize, byte xrcode, byte version) {
        this(payloadSize, xrcode, version, 0);
    }

    public OPTRecord(short payloadSize, byte xrcode, byte version, int flags) {
        super(Name.root, (short)41, payloadSize, (xrcode << 24) + (version << 16) + flags);
        this.options = null;
    }

    public short getExtendedRcode() {
        return (short)(this.ttl >>> 24);
    }

    public int getFlags() {
        return this.ttl & 0xFFFF;
    }

    public short getPayloadSize() {
        return this.dclass;
    }

    public short getVersion() {
        return (short)(this.ttl >>> 16 & 0xFF);
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("\t");
        sb.append(Type.string(this.getType()));
        if (this.options != null) {
            Enumeration e = this.options.keys();
            while (e.hasMoreElements()) {
                Integer i = (Integer)e.nextElement();
                sb.append(i + " ");
            }
        }
        sb.append(" ; payload ");
        sb.append(this.getPayloadSize());
        sb.append(", xrcode ");
        sb.append(this.getExtendedRcode());
        sb.append(", version ");
        sb.append(this.getVersion());
        sb.append(", flags ");
        sb.append(this.getFlags());
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.options == null) {
            return;
        }
        Enumeration e = this.options.keys();
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            short key = i.shortValue();
            out.writeShort(key);
            byte[] data = (byte[])this.options.get(i);
            out.writeShort(data.length);
            out.write(data);
        }
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        throw new IOException("An OPT should never be converted to canonical");
    }
}

