/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class LOCRecord
extends Record {
    private long size;
    private long hPrecision;
    private long vPrecision;
    private int latitude;
    private int longitude;
    private int altitude;

    private LOCRecord() {
    }

    public LOCRecord(Name _name, short _dclass, int _ttl, double _latitude, double _longitude, double _altitude, double _size, double _hPrecision, double _vPrecision) throws IOException {
        super(_name, (short)29, _dclass, _ttl);
        this.latitude = (int)(_latitude * 3600.0 * 1000.0 + -2.147483648E9);
        this.longitude = (int)(_longitude * 3600.0 * 1000.0 + -2.147483648E9);
        this.altitude = (int)((_altitude + 100000.0) * 100.0);
        this.size = (long)(_size * 100.0);
        this.hPrecision = (long)(_hPrecision * 100.0);
        this.vPrecision = (long)(_vPrecision * 100.0);
    }

    LOCRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)29, _dclass, _ttl);
        if (in == null) {
            return;
        }
        byte version = in.readByte();
        if (version != 0) {
            throw new WireParseException("Invalid LOC version");
        }
        this.size = this.parseLOCformat(in.readUnsignedByte());
        this.hPrecision = this.parseLOCformat(in.readUnsignedByte());
        this.vPrecision = this.parseLOCformat(in.readUnsignedByte());
        this.latitude = in.readInt();
        this.longitude = in.readInt();
        this.altitude = in.readInt();
    }

    LOCRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)29, _dclass, _ttl);
        String s = null;
        int min = 0;
        int deg = 0;
        double sec = 0.0;
        try {
            s = st.nextToken();
            deg = Integer.parseInt(s);
            s = st.nextToken();
            min = Integer.parseInt(s);
            s = st.nextToken();
            sec = new Double(s);
            s = st.nextToken();
        }
        catch (NumberFormatException numberFormatException) {}
        if (!s.equalsIgnoreCase("S") && !s.equalsIgnoreCase("N")) {
            throw new WireParseException("Invalid LOC latitude");
        }
        this.latitude = (int)(1000.0 * (sec + (double)(60 * (min + 60 * deg))));
        if (s.equalsIgnoreCase("S")) {
            this.latitude = -this.latitude;
        }
        this.latitude += Integer.MIN_VALUE;
        min = 0;
        deg = 0;
        sec = 0.0;
        try {
            s = st.nextToken();
            deg = Integer.parseInt(s);
            s = st.nextToken();
            min = Integer.parseInt(s);
            s = st.nextToken();
            sec = new Double(s);
            s = st.nextToken();
        }
        catch (NumberFormatException numberFormatException) {}
        if (!s.equalsIgnoreCase("W") && !s.equalsIgnoreCase("E")) {
            throw new WireParseException("Invalid LOC longitude");
        }
        this.longitude = (int)(1000.0 * (sec + (double)(60 * (min + 60 * deg))));
        if (s.equalsIgnoreCase("W")) {
            this.longitude = -this.longitude;
        }
        this.longitude += Integer.MIN_VALUE;
        if (!st.hasMoreTokens()) {
            return;
        }
        s = st.nextToken();
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.altitude = (int)((new Double(s) + 100000.0) * 100.0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC altitude");
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        s = st.nextToken();
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.size = (int)(100.0 * new Double(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC size");
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        s = st.nextToken();
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.hPrecision = (int)(100.0 * new Double(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC horizontal precision");
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        s = st.nextToken();
        if (s.length() > 1 && s.charAt(s.length() - 1) == 'm') {
            s = s.substring(0, s.length() - 1);
        }
        try {
            this.vPrecision = (int)(100.0 * new Double(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC vertical precision");
        }
    }

    public double getAltitude() {
        return (double)(this.altitude - 10000000) / 100.0;
    }

    public double getHPrecision() {
        return (double)this.hPrecision / 100.0;
    }

    public double getLatitude() {
        return (double)(this.latitude - Integer.MIN_VALUE) / 3600000.0;
    }

    public double getLongitude() {
        return (double)(this.longitude - Integer.MIN_VALUE) / 3600000.0;
    }

    public double getSize() {
        return (double)this.size / 100.0;
    }

    public double getVPrecision() {
        return (double)this.vPrecision / 100.0;
    }

    /*
     * Unable to fully structure code
     */
    private long parseLOCformat(int b) throws WireParseException {
        out = b >> 4;
        exp = b & 15;
        if (out <= 9L && exp <= 9) ** GOTO lbl6
        throw new WireParseException("Invalid LOC Encoding");
lbl-1000:
        // 1 sources

        {
            out *= 10L;
lbl6:
            // 2 sources

            ** while (exp-- > 0)
        }
lbl7:
        // 1 sources

        return out;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.latitude != 0 || this.longitude != 0 || this.altitude != 0) {
            char direction;
            DecimalFormat nf = new DecimalFormat();
            ((NumberFormat)nf).setMaximumFractionDigits(3);
            ((NumberFormat)nf).setGroupingUsed(false);
            long temp = (this.latitude & 0xFFFFFFFF) - Integer.MIN_VALUE;
            if (temp < 0L) {
                temp = -temp;
                direction = 'S';
            } else {
                direction = 'N';
            }
            sb.append(temp / 3600000L);
            sb.append(" ");
            sb.append((temp %= 3600000L) / 60000L);
            sb.append(" ");
            sb.append(nf.format((double)(temp %= 60000L) / 1000.0));
            sb.append(" ");
            sb.append(direction);
            sb.append(" ");
            temp = (this.longitude & 0xFFFFFFFF) - Integer.MIN_VALUE;
            if (temp < 0L) {
                temp = -temp;
                direction = 'W';
            } else {
                direction = 'E';
            }
            sb.append(temp / 3600000L);
            sb.append(" ");
            sb.append((temp %= 3600000L) / 60000L);
            sb.append(" ");
            sb.append(nf.format((double)(temp %= 60000L) / 1000.0));
            sb.append(" ");
            sb.append(direction);
            sb.append(" ");
            ((NumberFormat)nf).setMaximumFractionDigits(2);
            sb.append(nf.format((double)(this.altitude - 10000000) / 100.0));
            sb.append("m ");
            sb.append(nf.format((double)this.size / 100.0));
            sb.append("m ");
            sb.append(nf.format((double)this.hPrecision / 100.0));
            sb.append("m ");
            sb.append(nf.format((double)this.vPrecision / 100.0));
            sb.append("m");
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.latitude == 0 && this.longitude == 0 && this.altitude == 0) {
            return;
        }
        out.writeByte(0);
        out.writeByte(this.toLOCformat(this.size));
        out.writeByte(this.toLOCformat(this.hPrecision));
        out.writeByte(this.toLOCformat(this.vPrecision));
        out.writeInt(this.latitude);
        out.writeInt(this.longitude);
        out.writeInt(this.altitude);
    }

    private byte toLOCformat(long l) {
        long l2;
        int exp = 0;
        while (l2 > 9L) {
            exp = (byte)(exp + 1);
            l2 = (l + 5L) / 10L;
        }
        return (byte)((l2 << 4) + (long)exp);
    }
}

