/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Inet6Address {
    private byte[] data;

    public Inet6Address(int bits, byte[] data) throws IOException {
        if (data.length > 16) {
            throw new IOException("An Inet6Address is only 128 bits");
        }
        int bytes = (bits + 7) / 8;
        this.data = new byte[16];
        System.arraycopy(data, 0, this.data, 16 - bytes, bytes);
    }

    public Inet6Address(String s) throws IOException {
        boolean parsev4 = false;
        Vector<String> v = new Vector<String>();
        int range = -1;
        this.data = new byte[16];
        StringTokenizer st = new StringTokenizer(s, ":", true);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        v.addElement("");
        v.addElement("");
        String[] tokens = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            tokens[i] = (String)v.elementAt(i);
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < tokens.length - 2) {
            if (tokens[i].equals(":")) {
                if (tokens[i + 1].equals(":")) {
                    if (tokens[i + 2].equals(":") || range > 0) {
                        throw new IOException("Invalid IPv6 address");
                    }
                    range = j;
                    if (tokens[i + 2].equals("")) break;
                    ++i;
                }
                ++i;
            }
            if (tokens[i].indexOf(46) >= 0) {
                parsev4 = true;
                if (tokens[i + 1].equals("")) break;
                throw new IOException("Invalid IPv6 address");
            }
            try {
                int x = Integer.parseInt(tokens[i], 16);
                if (x > 65535) {
                    throw new IOException("Invalid IPv6 address");
                }
                if (j > 14) {
                    throw new IOException("Invalid IPv6 address");
                }
                this.data[j++] = (byte)(x >>> 8);
                this.data[j++] = (byte)(x & 0xFF);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Invalid IPv6 address");
            }
            ++i;
        }
        if (parsev4) {
            st = new StringTokenizer(tokens[i], ".");
            int k = 0;
            while (k < 4) {
                if (!st.hasMoreTokens()) {
                    throw new IOException("Invalid IPv6 address");
                }
                String token = st.nextToken();
                try {
                    this.data[j++] = (byte)Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Invalid IPv6 address");
                }
                ++k;
            }
        }
        if (range >= 0) {
            int left = 16 - j;
            int k = 0;
            while (k < j) {
                this.data[15 - k] = this.data[15 - k - left];
                ++k;
            }
            k = range;
            while (k < range + left) {
                this.data[k] = 0;
                ++k;
            }
        } else if (j < 16) {
            throw new IOException("Invalid IPv6 address");
        }
    }

    public Inet6Address(byte[] data) throws IOException {
        if (data.length != 16) {
            throw new IOException("An Inet6Address is 128 bits");
        }
        this.data = data;
    }

    public static void main(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            Inet6Address addr6 = new Inet6Address(args[i]);
            System.out.println(String.valueOf(args[i]) + " -> " + addr6);
            ++i;
        }
    }

    public byte[] toBytes() {
        return this.data;
    }

    public String toString() {
        int[] labels = new int[8];
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 8) {
            labels[i] = ((this.data[2 * i] & 0xFF) << 8) + (this.data[2 * i + 1] & 0xFF);
            ++i;
        }
        int start = -1;
        int length = -1;
        int tstart = -1;
        int tlength = -1;
        boolean inzero = false;
        int i2 = 0;
        while (i2 < 8) {
            if (!inzero) {
                if (labels[i2] == 0) {
                    tstart = i2;
                    tlength = 0;
                    inzero = true;
                }
            } else if (labels[i2] == 0) {
                ++tlength;
            } else {
                inzero = false;
                if (tlength > length) {
                    start = tstart;
                    length = tlength;
                }
                tlength = -1;
            }
            ++i2;
        }
        if (tlength > length) {
            start = tstart;
            length = tlength;
        }
        if (start == -1) {
            i2 = 0;
            while (i2 < 8) {
                sb.append(Integer.toHexString(labels[i2]).toUpperCase());
                if (i2 != 7) {
                    sb.append(":");
                }
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < start) {
                sb.append(Integer.toHexString(labels[i2]).toUpperCase());
                sb.append(":");
                ++i2;
            }
            if (start == 0) {
                sb.append(":");
            }
            sb.append(":");
            i2 = start + length + 1;
            while (i2 < 8) {
                sb.append(Integer.toHexString(labels[i2]).toUpperCase());
                if (i2 != 7) {
                    sb.append(":");
                }
                ++i2;
            }
        }
        return sb.toString();
    }
}

