/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.util;

import de.zwanzigeins.util.LogContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.util.Helper;

public class UserAlias {
    private Hashtable hshAlias = null;
    private LogContext logContext = null;
    private Vector vecFilesRead = null;
    private Vector vecResolved = null;
    private int intDepth = 0;
    private static final int MAX_DEPTH = 5;

    public UserAlias(String[] stringArray) {
        this(stringArray, null);
    }

    public UserAlias(String[] stringArray, LogContext logContext) {
        this.logContext = logContext;
        this.hshAlias = new Hashtable();
        this.vecFilesRead = new Vector();
        this.readAliases(stringArray);
    }

    private void addAlias(String string, String string2) {
        String string3 = (String)this.hshAlias.get(string);
        if (string3 == null) {
            this.hshAlias.put(string, string2);
            return;
        }
        this.hshAlias.put(string, String.valueOf(string3) + ", " + string2);
    }

    private void addInclude_1(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        String string2 = file.getAbsolutePath();
        if (this.vecFilesRead.indexOf(string2) != -1) {
            if (this.logContext != null) {
                this.logContext.write("! double include of " + string2 + " ignored");
            }
            return;
        }
        this.vecFilesRead.addElement(string2);
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = null;
                Vector<String> vector = new Vector<String>();
                while ((string3 = bufferedReader.readLine()) != null) {
                    if ((string3 = string3.trim()).length() < 2 || string3.startsWith("#")) continue;
                    vector.addElement(string3);
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.readAliases((String[])objectArray);
            }
            catch (IOException iOException) {
                if (this.logContext != null) {
                    this.logContext.write("? alias:addInclude " + iOException.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            Helper.close(bufferedReader);
            throw throwable;
        }
        Object var5_11 = null;
        Helper.close(bufferedReader);
    }

    private void addInclude_2(String string, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            return;
        }
        String string3 = file.getAbsolutePath();
        if (this.vecFilesRead.indexOf(string3) != -1) {
            if (this.logContext != null) {
                this.logContext.write("! double include of " + string3 + " ignored");
            }
            return;
        }
        this.vecFilesRead.addElement(string3);
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    if ((string4 = string4.trim()).length() < 2 || string4.startsWith("#")) continue;
                    this.addAlias(string, string4);
                }
            }
            catch (IOException iOException) {
                if (this.logContext != null) {
                    this.logContext.write("? alias:addInclude " + iOException.getMessage());
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Helper.close(bufferedReader);
            throw throwable;
        }
        Object var6_10 = null;
        Helper.close(bufferedReader);
    }

    private String getLeft(String string) {
        int n = string.indexOf(":", 1);
        if (n == -1) {
            return null;
        }
        if ((string = string.substring(0, n).trim()).length() == 0) {
            return null;
        }
        return string.toLowerCase();
    }

    private String getRight(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return null;
        }
        if ((string = string.substring(n + 1).trim()).length() == 0) {
            return null;
        }
        return string.toLowerCase();
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("test1: :include:n:\\alias.txt");
        vector.addElement("postmaster: hohmann@harddiskcafe.de");
        vector.addElement("news:       postmaster");
        vector.addElement("newsadmin:  postmaster");
        vector.addElement("newsadm:    postmaster");
        vector.addElement("webmaster:  postmaster, bernd.hohmann@zwanzigeins.de");
        vector.addElement("mail:\t\tpostmaster");
        vector.addElement("root:       postmaster");
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        UserAlias userAlias = new UserAlias((String[])objectArray);
        String string = "hohmann@harddiskcafe.de";
        String[] stringArray2 = userAlias.resolve(string);
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(n + " " + string + " " + stringArray2[n]);
            ++n;
        }
        System.out.println("**end**");
    }

    private void readAliases(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = this.getLeft(stringArray[n]);
            String string2 = this.getRight(stringArray[n]);
            if (string != null && string2 != null) {
                if (string.toLowerCase().startsWith(":include")) {
                    string2 = string2.substring(8).trim();
                    this.addInclude_1(string2);
                } else if (string2.toLowerCase().startsWith(":include:")) {
                    string2 = string2.substring(9).trim();
                    this.addInclude_2(string, string2);
                } else if (!string2.startsWith(":")) {
                    this.addAlias(string, string2);
                }
            }
            ++n;
        }
    }

    public String[] resolve(String string) {
        this.vecResolved = new Vector();
        this.resolve0(string.toLowerCase());
        Object[] objectArray = new String[this.vecResolved.size()];
        this.vecResolved.copyInto(objectArray);
        return objectArray;
    }

    private void resolve0(String string) {
        if (this.intDepth > 5) {
            if (this.logContext != null) {
                this.logContext.write("? Alias: over-recursion ignored");
            }
            return;
        }
        ++this.intDepth;
        String string2 = (String)this.hshAlias.get(string);
        if (string2 == null) {
            this.vecResolved.addElement(string);
            --this.intDepth;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.resolve0(stringTokenizer.nextToken().trim());
        }
        --this.intDepth;
    }
}

