/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.util;

import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import net.zerotoaster.config.Configuration;
import net.zerotoaster.util.Helper;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.dns;

public class RBLCheck {
    private Configuration cnf = null;
    private LogContext log = null;
    private String strTXTResult = "";
    private long lngTimeNeeded = 0L;
    private static final Object objLock = new Object();

    public RBLCheck(LogContext logContext, Configuration configuration) {
        this.cnf = configuration;
        this.log = logContext;
    }

    public boolean check(String string, String string2, String string3) {
        this.lngTimeNeeded = 0L;
        this.strTXTResult = "";
        long l = TimeFactory.getTime();
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string4 = String.valueOf(stringTokenizer.nextToken()) + "." + string4;
        }
        if (string4.length() < 5) {
            this.log("Not a valid IP " + string);
            return false;
        }
        String string5 = String.valueOf(Helper.lset(string, 15, ' ')) + "/" + string2 + " ";
        Record[] recordArray = dns.getRecords((String)(String.valueOf(string4) + string2), (short)1);
        if (recordArray == null) {
            this.log(String.valueOf(string5) + "--> Not in RBL");
            this.strTXTResult = "Not in RBL";
            return false;
        }
        Record[] recordArray2 = dns.getRecords((String)(String.valueOf(string4) + string2), (short)16);
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken().trim());
            stringBuffer.append("#");
        }
        string3 = stringBuffer.toString();
        boolean bl = false;
        String string6 = "";
        int n = 0;
        while (n < recordArray.length) {
            String string7;
            if (string3.length() <= 0 || string3.indexOf(string7 = String.valueOf(((ARecord)recordArray[n]).getAddress().getHostAddress()) + "#") != -1) {
                if (recordArray2 != null && recordArray2.length == recordArray.length) {
                    string6 = (String)((TXTRecord)recordArray2[n]).getStrings().elementAt(0);
                }
                if (string6.length() == 0) {
                    string6 = "RBL Blocked by " + string2;
                }
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            string6 = "Found, but no matching result";
        }
        this.log(String.valueOf(string5) + "--> " + string6);
        this.lngTimeNeeded = TimeFactory.getTime() - l;
        this.strTXTResult = string6;
        return bl;
    }

    public void dispose() {
        this.cnf = null;
        this.log = null;
    }

    public String getMessage() {
        return this.strTXTResult;
    }

    public long getTime() {
        return this.lngTimeNeeded;
    }

    private void log(String string) {
        if (this.cnf == null || this.cnf.strRBL_Logfile.length() == 0) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            Object object = objLock;
            synchronized (object) {
                string = String.valueOf(Helper.formatDateTime(TimeFactory.getTime())) + " RBL " + string;
                printWriter = new PrintWriter(new FileWriter(Helper.platformPath(this.cnf.strRBL_Logfile), true));
                printWriter.println(string);
                printWriter.flush();
                Helper.close(printWriter);
            }
        }
        catch (Throwable throwable) {
            Helper.close(printWriter);
            Helper.writeLog(throwable);
        }
    }

    public static void main(String[] stringArray) {
        RBLCheck rBLCheck = new RBLCheck(null, Configuration.getConfig());
        if (stringArray.length < 2) {
            stringArray = new String[]{"66.249.106.194", "bl.spamcop.net"};
        }
        System.out.println("[Scanning]");
        if (rBLCheck.check(stringArray[0], stringArray[1], "127.0.0.2")) {
            System.out.println(String.valueOf(stringArray[0]) + " / " + stringArray[1] + ": " + rBLCheck.getMessage());
        } else {
            System.out.println(String.valueOf(stringArray[0]) + " / " + stringArray[1] + ": " + rBLCheck.getMessage());
        }
        System.out.println("[End of query]");
        rBLCheck.dispose();
    }
}

