/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.util;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperValidate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.config.Constants;
import net.zerotoaster.io.LineServerSocket;
import net.zerotoaster.io.LineSocket;
import net.zerotoaster.storage.DomainRecord;
import net.zerotoaster.storage.StorageManager;
import net.zerotoaster.storage.UserRecord;
import net.zerotoaster.util.HostIP;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;

public class Helper
implements Constants {
    private static final int CASEDIFF = 32;
    private static final Object objLock = new Object();

    private Helper() {
    }

    public static final String buildID(int n, int n2) {
        int n3 = 48;
        String string = String.valueOf(n);
        String string2 = String.valueOf(n2);
        int n4 = string2.length();
        int n5 = string.length();
        if (n5 > n4) {
            n5 = n4;
        }
        byte[] byArray = new byte[n4];
        int n6 = 0;
        while (n6 < n4 - n5) {
            byArray[n6] = n3;
            ++n6;
        }
        n6 = 0;
        while (n6 < n5) {
            byArray[n6 + n4 - n5] = (byte)string.charAt(n6);
            ++n6;
        }
        return "[" + new String(byArray) + "/" + string2 + "]";
    }

    public static final boolean checkString(String string, String string2) {
        string = string.toLowerCase();
        int n = (string2 = string2.toLowerCase()).indexOf(42);
        if (n == -1) {
            return string.equals(string2);
        }
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        while (n4 < n2) {
            if (string2.charAt(n4) == '*') {
                bl = true;
                ++n4;
                continue;
            }
            int n6 = string2.indexOf(42, n4);
            if (n6 == -1) {
                n6 = n2;
            }
            String string3 = string2.substring(n4, n6);
            n4 = n6;
            if (bl) {
                int n7 = string.indexOf(string3);
                if (n7 == -1) {
                    return false;
                }
                n5 = n7 + string3.length();
            } else {
                if (!string.regionMatches(false, 0, string3, 0, string3.length())) {
                    return false;
                }
                n5 += string3.length();
            }
            bl = false;
        }
        return bl ? true : n5 == n3;
    }

    public static final boolean close(Object object) {
        if (object == null) {
            return true;
        }
        try {
            if (object instanceof RandomAccessFile) {
                ((RandomAccessFile)object).close();
                return true;
            }
            if (object instanceof InputStream) {
                ((InputStream)object).close();
                return true;
            }
            if (object instanceof OutputStream) {
                ((OutputStream)object).close();
                return true;
            }
            if (object instanceof Writer) {
                ((Writer)object).close();
                return true;
            }
            if (object instanceof Reader) {
                ((Reader)object).close();
                return true;
            }
            if (object instanceof LineSocket) {
                ((LineSocket)object).close();
                return true;
            }
            if (object instanceof LineServerSocket) {
                ((LineServerSocket)object).close();
                return true;
            }
            if (object instanceof ServerSocket) {
                ((ServerSocket)object).close();
                return true;
            }
            if (object instanceof Socket) {
                ((Socket)object).close();
                return true;
            }
            if (object instanceof Connection) {
                ((Connection)object).close();
                return true;
            }
            if (object instanceof Statement) {
                ((Statement)object).close();
                return true;
            }
            if (object instanceof PreparedStatement) {
                ((PreparedStatement)object).close();
                return true;
            }
            if (object instanceof ResultSet) {
                ((ResultSet)object).close();
                return true;
            }
            Helper.writeLog("Unknown close object: " + object);
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static final void flush(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof OutputStream) {
                ((OutputStream)object).flush();
                return;
            }
            if (object instanceof Writer) {
                ((Writer)object).flush();
                return;
            }
            if (object instanceof LineSocket) {
                ((LineSocket)object).flush();
                return;
            }
            Helper.writeLog("Unknown flush object: " + object);
        }
        catch (Throwable throwable) {}
    }

    public static final String formatDate(long l) {
        if (l <= 0L) {
            return "";
        }
        DateFormat dateFormat = DateFormat.getDateInstance();
        return dateFormat.format(new Date(l));
    }

    public static final String formatDateTime(long l) {
        if (l <= 0L) {
            return "";
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(new Date(l));
    }

    public static final String formatMemoryString(long l) {
        double d = l;
        String string = " Bt";
        if (l > 0x10000000000L) {
            d = (double)l / 1.099511627776E12;
            string = " TB";
        } else if (l > 0x40000000L) {
            d = (double)l / 1.073741824E9;
            string = " GB";
        } else if (l >= 0x100000L) {
            d = (double)l / 1048576.0;
            string = " MB";
        } else if (l >= 1024L) {
            d = (double)l / 1024.0;
            string = " KB";
        }
        if (!string.equals(" Bt")) {
            String string2 = String.valueOf(d = (double)Math.round(d * 100.0) / 100.0);
            int n = string2.indexOf(46);
            if (n == -1) {
                string2 = String.valueOf(string2) + ".00";
            } else {
                int n2 = string2.length() - n;
                if (n2 < 3) {
                    string2 = String.valueOf(string2) + "0";
                } else if (n2 > 3) {
                    string2 = string2.substring(0, n + 2);
                }
            }
            return d + string;
        }
        return l + string;
    }

    public static final String formatTime(long l) {
        if (l <= 0L) {
            return "";
        }
        DateFormat dateFormat = DateFormat.getTimeInstance();
        return dateFormat.format(new Date(l));
    }

    public static final String getArg(String string) {
        int n = string.indexOf(" ");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1).trim();
    }

    public static final String getCmd(String string) {
        int n = string.indexOf(" ");
        if (n == -1) {
            return string.trim();
        }
        return string.substring(0, n).trim();
    }

    public static final HostIP[] getMXHosts(String string, boolean bl) throws Throwable {
        Object object;
        Object object2;
        int n;
        if (string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1);
            string = string.substring(0, string.length() - 1);
            HostIP hostIP = new HostIP();
            hostIP.strHost = string;
            hostIP.strIP = string;
            return new HostIP[]{hostIP};
        }
        Record[] recordArray = null;
        int n2 = 0;
        while (n2 < 5) {
            recordArray = dns.getRecords((String)string, (short)15);
            if (recordArray == null) {
                recordArray = dns.getRecords((String)string, (short)1);
            }
            if (recordArray != null || bl) break;
            Thread.sleep(750L);
            ++n2;
        }
        if (recordArray == null) {
            return null;
        }
        if (recordArray[0] instanceof MXRecord && recordArray.length > 0) {
            do {
                n2 = 0;
                n = 0;
                while (n < recordArray.length - 1) {
                    object2 = (MXRecord)recordArray[n];
                    object = (MXRecord)recordArray[n + 1];
                    if (object2.getPriority() > object.getPriority()) {
                        recordArray[n] = object;
                        recordArray[n + 1] = object2;
                        n2 = 1;
                    }
                    ++n;
                }
            } while (n2 != 0);
        }
        String[] stringArray = new String[recordArray.length];
        n = 0;
        while (n < recordArray.length) {
            object2 = recordArray[n] instanceof MXRecord ? ((MXRecord)recordArray[n]).getTarget().toString() : ((ARecord)recordArray[n]).getName().toString();
            if (((String)object2).endsWith(".")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            stringArray[n] = object2;
            ++n;
        }
        Vector<Object> vector = new Vector<Object>(stringArray.length);
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (HelperValidate.isIP((String)stringArray[n3])) {
                object = new HostIP();
                object.strHost = stringArray[n3];
                object.strIP = stringArray[n3];
                vector.addElement(object);
            }
            if ((recordArray = dns.getRecords((String)stringArray[n3], (short)1)) != null) {
                int n4 = 0;
                while (n4 < recordArray.length) {
                    ARecord aRecord = (ARecord)recordArray[n4];
                    HostIP hostIP = new HostIP();
                    hostIP.strHost = stringArray[n3];
                    hostIP.strIP = aRecord.rdataToString();
                    if (hostIP.strIP.length() > 0) {
                        vector.addElement(hostIP);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        Object[] objectArray = new HostIP[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static final String getSMTPUser(String string) {
        if (string == null) {
            return "<null>";
        }
        int n = string.lastIndexOf(60) + 1;
        int n2 = string.indexOf(62, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n == n2) {
            return "";
        }
        return string.substring(n, n2);
    }

    public static final byte[] hmac_md5(String string, String string2) {
        int n = 64;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length > n) {
            byArray = messageDigest.digest(byArray);
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[n2] = (byte)(byArray[n2] ^ 0x36);
            ++n2;
        }
        n2 = byArray.length;
        while (n2 < n) {
            byArray2[n2] = 54;
            ++n2;
        }
        messageDigest.update(byArray2);
        messageDigest.update(string2.getBytes());
        byte[] byArray3 = messageDigest.digest();
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray2[n3] = (byte)(byArray[n3] ^ 0x5C);
            ++n3;
        }
        n3 = byArray.length;
        while (n3 < n) {
            byArray2[n3] = 92;
            ++n3;
        }
        messageDigest.update(byArray2);
        messageDigest.update(byArray3);
        return messageDigest.digest();
    }

    public static final String limit(String string, int n) {
        return string.length() > n ? string.substring(0, n) : string;
    }

    public static String lset(long l, int n, char c) {
        return Helper.lset(Long.toString(l), n, c);
    }

    public static String lset(String string, int n, char c) {
        byte by = (byte)c;
        int n2 = string.length();
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)string.charAt(n3);
            ++n3;
        }
        n3 = n2++;
        while (n3 < n) {
            byArray[n3] = by;
            ++n3;
        }
        return new String(byArray);
    }

    public static void main(String[] stringArray) throws Throwable {
        ((Hashtable)System.getProperties()).put("dns.server", "daisy.harddiskcafe.de");
        HostIP[] hostIPArray = Helper.getMXHosts("softal.de", false);
        int n = 0;
        while (n < hostIPArray.length) {
            System.out.println(hostIPArray[n]);
            ++n;
        }
    }

    public static final String platformPath(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        return string;
    }

    public static final Vector processGroup(String string) {
        Vector vector = new Vector();
        Helper.processGroup0(string, vector, new File("c:\\mptn\\etc\\groups.tcp"));
        Helper.processGroup0(string, vector, new File("groupcopy.ini"));
        return vector;
    }

    private static final void processGroup0(String string, Vector vector, File file) {
        String string2;
        if (string.length() == 0) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.length() == 0L) {
            return;
        }
        BufferedReader bufferedReader = null;
        String string3 = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf("=") == -1 || !string2.startsWith(string)) continue;
                    string3 = string2;
                    break;
                }
            }
            catch (IOException iOException) {
                Object var5_7 = null;
                Helper.close(bufferedReader);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            Helper.close(bufferedReader);
            throw throwable;
        }
        StringTokenizer stringTokenizer = null;
        Helper.close(bufferedReader);
        if (string3 == null) {
            return;
        }
        string3 = string3.substring(string3.indexOf("=") + 1).trim();
        stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0 || vector.indexOf(string2) != -1) continue;
            vector.addElement(string2);
        }
    }

    public static final String redirectUser(String string, StorageManager storageManager) {
        int n;
        String string2 = HelperExtract.splitUserName_getDomain((String)string);
        String string3 = HelperExtract.splitUserName_getUser((String)string);
        DomainRecord domainRecord = null;
        UserRecord userRecord = null;
        userRecord = storageManager.userRead(string);
        if (userRecord == null) {
            n = 0;
            while (n < 5) {
                domainRecord = storageManager.domainRead(string2);
                if (domainRecord == null || domainRecord.getDomainAlias().length() == 0) break;
                string2 = domainRecord.getDomainAlias();
                ++n;
            }
            string = String.valueOf(string3) + "@" + string2;
        }
        n = 0;
        int n2 = 0;
        while (n2 < 5) {
            userRecord = storageManager.userRead(string);
            int n3 = n = n != 0 || userRecord != null ? 1 : 0;
            if (userRecord == null || userRecord.getRedirect().length() == 0) break;
            string = userRecord.getRedirect();
            ++n2;
        }
        return string;
    }

    public static final boolean rollback(Connection connection) {
        if (connection == null) {
            return true;
        }
        try {
            connection.rollback();
            return true;
        }
        catch (Throwable throwable) {
            Helper.writeLog(throwable);
            return false;
        }
    }

    public static String rset(long l, int n, char c) {
        return Helper.rset(Long.toString(l), n, c);
    }

    public static String rset(String string, int n, char c) {
        byte by = (byte)c;
        int n2 = string.length();
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < n - n2) {
            byArray[n3] = by;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            byArray[n3 + n - n2] = (byte)string.charAt(n3);
            ++n3;
        }
        return new String(byArray);
    }

    public static final void sortVector(Vector vector) {
        boolean bl = false;
        do {
            bl = false;
            int n = 0;
            while (n < vector.size() - 1) {
                String string;
                String string2 = (String)vector.elementAt(n);
                if (string2.compareTo(string = (String)vector.elementAt(n + 1)) > 0) {
                    vector.setElementAt(string, n);
                    vector.setElementAt(string2, n + 1);
                    bl = true;
                }
                ++n;
            }
        } while (bl);
    }

    public static final String splitListName_getCommand(String string) {
        int n = string.indexOf("-");
        if (n == -1) {
            return null;
        }
        return HelperExtract.splitUserName_getUser((String)string.substring(n + 1));
    }

    public static final String splitListName_getList(String string) {
        int n = string.indexOf("-");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(n + 1);
        return String.valueOf(string.substring(0, n)) + "@" + HelperExtract.splitUserName_getDomain((String)string2);
    }

    public static final String validateFileName(String string) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        boolean bl = true;
        int n = 0;
        while (n < string.length() && bl) {
            char c = string.charAt(n);
            if (c < ' ') {
                bl = false;
            }
            if (c > 'z') {
                bl = false;
            }
            ++n;
        }
        return bl ? string : null;
    }

    public static final void writeLog(String string) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter("err.dmp", true));
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable) {
                System.err.println("writeLog: " + throwable);
            }
        }
    }

    public static final void writeLog(Throwable throwable) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter("err.dmp", true));
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable2) {
                System.err.println("writeLog: " + throwable2);
            }
        }
    }
}

