/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import net.zerotoaster.util.Helper;
import net.zerotoaster.util.HostIP;

public class MXMonitor {
    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length != 3) {
            System.out.println("MX Resolver test");
            System.out.println("Usage: domain.tld interval_in_minutes dns_to_use,dns_to_use");
            System.out.println("Example: zerotoaster.net 15 donald.harddiskcafe.de,daisy.harddiskcafe.de");
            System.out.println("Result will be written into mxchk_domain.tld");
            return;
        }
        String string = stringArray[0];
        long l = Long.parseLong(stringArray[1]) * 1000L * 60L;
        String string2 = stringArray[2];
        ((Hashtable)System.getProperties()).put("dns.server", string2);
        String string3 = "mxchk_" + string;
        new File(string3).delete();
        while (true) {
            System.out.println("checking " + string);
            PrintWriter printWriter = null;
            printWriter = new PrintWriter((Writer)new FileWriter(string3, true), true);
            Date date = new Date();
            try {
                printWriter.println(date + " Checking " + string);
                HostIP[] hostIPArray = Helper.getMXHosts(string, false);
                if (hostIPArray == null) {
                    printWriter.println(date + " got NULL");
                } else {
                    printWriter.println(date + " " + hostIPArray.length + " Hosts");
                    printWriter.print(date + " ");
                    int n = 0;
                    while (n < hostIPArray.length) {
                        printWriter.print(hostIPArray[n].toString());
                        printWriter.print(", ");
                        ++n;
                    }
                    printWriter.println();
                }
            }
            catch (Throwable throwable) {
                printWriter.println(date + " Error " + throwable.toString());
            }
            Helper.close(printWriter);
            System.out.println("sleeping");
            Thread.sleep(l);
        }
    }
}

